/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.dbunit.database.CachedResultSetTable;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseDataSet;
import org.dbunit.database.DatabaseTableMetaData;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.statement.IStatementFactory;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.datatype.IDataTypeFactory;

public abstract class AbstractDatabaseConnection
implements IDatabaseConnection {
    private IDataSet _dataSet = null;
    private DatabaseConfig _databaseConfig = new DatabaseConfig();

    public IDataSet createDataSet() throws SQLException {
        if (this._dataSet == null) {
            this._dataSet = new DatabaseDataSet(this);
        }
        return this._dataSet;
    }

    public IDataSet createDataSet(String[] tableNames) throws SQLException {
        return new FilteredDataSet(tableNames, this.createDataSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITable createQueryTable(String resultName, String sql) throws DataSetException, SQLException {
        Statement statement = this.getConnection().createStatement();
        try {
            CachedResultSetTable cachedResultSetTable;
            ResultSet resultSet = statement.executeQuery(sql);
            try {
                IDataTypeFactory typeFactory = (IDataTypeFactory)this._databaseConfig.getProperty("http://www.dbunit.org/properties/datatypeFactory");
                ITableMetaData metaData = DatabaseTableMetaData.createMetaData(resultName, resultSet, typeFactory);
                cachedResultSetTable = new CachedResultSetTable(metaData, resultSet);
            }
            catch (Throwable throwable) {
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            return cachedResultSetTable;
        }
        finally {
            statement.close();
        }
    }

    public int getRowCount(String tableName) throws SQLException {
        return this.getRowCount(tableName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount(String tableName, String whereClause) throws SQLException {
        StringBuffer sqlBuffer = new StringBuffer(128);
        sqlBuffer.append("select count(*) from ");
        sqlBuffer.append(tableName);
        if (whereClause != null) {
            sqlBuffer.append(" ");
            sqlBuffer.append(whereClause);
        }
        Statement statement = this.getConnection().createStatement();
        try {
            int n;
            ResultSet resultSet = statement.executeQuery(sqlBuffer.toString());
            try {
                resultSet.next();
                n = resultSet.getInt(1);
            }
            catch (Throwable throwable) {
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            return n;
        }
        finally {
            statement.close();
        }
    }

    public DatabaseConfig getConfig() {
        return this._databaseConfig;
    }

    public IStatementFactory getStatementFactory() {
        return (IStatementFactory)this._databaseConfig.getProperty("http://www.dbunit.org/properties/statementFactory");
    }

    public abstract /* synthetic */ void close() throws SQLException;

    public abstract /* synthetic */ String getSchema();

    public abstract /* synthetic */ Connection getConnection() throws SQLException;
}

