/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.filter.SequenceTableFilter;

public class DatabaseSequenceFilter
extends SequenceTableFilter {
    private static Map _dependentMap;

    public DatabaseSequenceFilter(IDatabaseConnection connection, String[] tableNames) throws DataSetException, SQLException {
        super(DatabaseSequenceFilter.sortTableNames(connection, tableNames));
    }

    public DatabaseSequenceFilter(IDatabaseConnection connection) throws DataSetException, SQLException {
        this(connection, connection.createDataSet().getTableNames());
    }

    static String[] sortTableNames(IDatabaseConnection connection, String[] tableNames) throws DataSetException, SQLException {
        boolean reprocess = true;
        List tmpTableNames = Arrays.asList(tableNames);
        LinkedList<String> sortedTableNames = null;
        _dependentMap = new HashMap();
        while (reprocess) {
            sortedTableNames = new LinkedList<String>();
            Iterator<String> i = tmpTableNames.iterator();
            while (i.hasNext()) {
                boolean foundDependentInSortedTableNames = false;
                String tmpTable = i.next();
                Set tmpTableDependents = DatabaseSequenceFilter.getDependentTableNames(connection, tmpTable);
                int sortedTableIndex = -1;
                Iterator k = sortedTableNames.iterator();
                while (k.hasNext()) {
                    String sortedTable = (String)k.next();
                    if (!tmpTableDependents.contains(sortedTable)) continue;
                    sortedTableIndex = sortedTableNames.indexOf(sortedTable);
                    foundDependentInSortedTableNames = true;
                    break;
                }
                if (foundDependentInSortedTableNames) {
                    if (sortedTableIndex < 0) {
                        throw new IllegalStateException("sortedTableIndex should be 0 or greater, but is " + sortedTableIndex);
                    }
                    sortedTableNames.add(sortedTableIndex, tmpTable);
                    continue;
                }
                sortedTableNames.add(tmpTable);
            }
            if (((Object)tmpTableNames).equals(sortedTableNames)) {
                reprocess = false;
                continue;
            }
            tmpTableNames = null;
            tmpTableNames = (List)sortedTableNames.clone();
        }
        return sortedTableNames.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set getDependentTableNames(IDatabaseConnection connection, String tableName) throws SQLException {
        if (_dependentMap.containsKey(tableName)) {
            return (Set)_dependentMap.get(tableName);
        }
        DatabaseMetaData metaData = connection.getConnection().getMetaData();
        String schema = connection.getSchema();
        ResultSet resultSet = metaData.getExportedKeys(null, schema, tableName);
        try {
            HashSet<String> foreignTableSet = new HashSet<String>();
            while (resultSet.next()) {
                String foreignTableName = resultSet.getString(7);
                foreignTableSet.add(foreignTableName);
            }
            _dependentMap.put(tableName, foreignTableSet);
            HashSet<String> hashSet = foreignTableSet;
            return hashSet;
        }
        finally {
            resultSet.close();
        }
    }
}

