/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.AbstractTable;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.RowOutOfBoundsException;

public class CompositeTable
extends AbstractTable {
    private final ITableMetaData _metaData;
    private final ITable[] _tables;

    public CompositeTable(ITableMetaData metaData, ITable table) {
        this._metaData = metaData;
        this._tables = new ITable[]{table};
    }

    public CompositeTable(ITableMetaData metaData, ITable[] tables) {
        this._metaData = metaData;
        this._tables = tables;
    }

    public CompositeTable(ITable table1, ITable table2) {
        this._metaData = table1.getTableMetaData();
        this._tables = new ITable[]{table1, table2};
    }

    public CompositeTable(String newName, ITable table) throws DataSetException {
        ITableMetaData metaData = table.getTableMetaData();
        this._metaData = new DefaultTableMetaData(newName, metaData.getColumns(), metaData.getPrimaryKeys());
        this._tables = new ITable[]{table};
    }

    public ITableMetaData getTableMetaData() {
        return this._metaData;
    }

    public int getRowCount() {
        int totalCount = 0;
        for (int i = 0; i < this._tables.length; ++i) {
            ITable table = this._tables[i];
            totalCount += table.getRowCount();
        }
        return totalCount;
    }

    public Object getValue(int row, String column) throws DataSetException {
        if (row < 0) {
            throw new RowOutOfBoundsException(row + " < 0 ");
        }
        int totalCount = 0;
        for (int i = 0; i < this._tables.length; ++i) {
            ITable table = this._tables[i];
            int count = table.getRowCount();
            if (totalCount + count > row) {
                return table.getValue(row - totalCount, column);
            }
            totalCount += count;
        }
        throw new RowOutOfBoundsException(row + " > " + totalCount);
    }
}

