/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;

public class ReplacementTable
implements ITable {
    private final ITable _table;
    private final Map _objectMap;
    private final Map _substringMap;
    private String _startDelim;
    private String _endDelim;

    public ReplacementTable(ITable table) {
        this(table, new HashMap(), new HashMap(), null, null);
    }

    public ReplacementTable(ITable table, Map objectMap, Map substringMap, String startDelimiter, String endDelimiter) {
        this._table = table;
        this._objectMap = objectMap;
        this._substringMap = substringMap;
        this._startDelim = startDelimiter;
        this._endDelim = endDelimiter;
    }

    public void addReplacementObject(Object originalObject, Object replacementObject) {
        this._objectMap.put(originalObject, replacementObject);
    }

    public void addReplacementSubstring(String originalSubstring, String replacementSubstring) {
        if (originalSubstring == null || replacementSubstring == null) {
            throw new NullPointerException();
        }
        this._substringMap.put(originalSubstring, replacementSubstring);
    }

    public void setSubstringDelimiters(String startDelimiter, String endDelimiter) {
        if (startDelimiter == null || endDelimiter == null) {
            throw new NullPointerException();
        }
        this._startDelim = startDelimiter;
        this._endDelim = endDelimiter;
    }

    private String replaceSubstrings(String value) {
        StringBuffer buffer = null;
        Iterator it = this._substringMap.entrySet().iterator();
        block0: while (it.hasNext()) {
            Map.Entry entry = it.next();
            String original = (String)entry.getKey();
            String replacement = (String)entry.getValue();
            int startIndex = 0;
            int lastEndIndex = 0;
            while (true) {
                if ((startIndex = value.indexOf(original, lastEndIndex)) == -1) {
                    if (buffer == null) continue block0;
                    buffer.append(value.substring(lastEndIndex));
                    continue block0;
                }
                if (buffer == null) {
                    buffer = new StringBuffer();
                }
                buffer.append(value.substring(lastEndIndex, startIndex));
                buffer.append(replacement);
                lastEndIndex = startIndex + original.length();
            }
        }
        return buffer == null ? value : buffer.toString();
    }

    private String replaceDelimitedSubstrings(String value) {
        StringBuffer buffer = null;
        int startIndex = 0;
        int endIndex = 0;
        int lastEndIndex = 0;
        do {
            String substring;
            if ((startIndex = value.indexOf(this._startDelim, lastEndIndex)) == -1 || (endIndex = value.indexOf(this._endDelim, startIndex + this._startDelim.length())) == -1) continue;
            if (buffer == null) {
                buffer = new StringBuffer();
            }
            if (this._substringMap.containsKey(substring = value.substring(startIndex + this._startDelim.length(), endIndex))) {
                buffer.append(value.substring(lastEndIndex, startIndex));
                buffer.append(this._substringMap.get(substring));
            } else {
                buffer.append(value.substring(lastEndIndex, endIndex + this._endDelim.length()));
            }
            lastEndIndex = endIndex + this._endDelim.length();
        } while (startIndex != -1 && endIndex != -1);
        if (buffer != null) {
            buffer.append(value.substring(lastEndIndex));
        }
        return buffer == null ? value : buffer.toString();
    }

    public ITableMetaData getTableMetaData() {
        return this._table.getTableMetaData();
    }

    public int getRowCount() {
        return this._table.getRowCount();
    }

    public Object getValue(int row, String column) throws DataSetException {
        Object value = this._table.getValue(row, column);
        if (this._objectMap.containsKey(value)) {
            return this._objectMap.get(value);
        }
        if (this._substringMap.size() == 0 || !(value instanceof String)) {
            return value;
        }
        if (this._startDelim != null && this._endDelim != null) {
            return this.replaceDelimitedSubstrings((String)value);
        }
        return this.replaceSubstrings((String)value);
    }
}

