/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.sql.Connection;
import java.sql.SQLException;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.dbunit.operation.ExclusiveTransactionException;

public class TransactionOperation
extends DatabaseOperation {
    private final DatabaseOperation _operation;

    public TransactionOperation(DatabaseOperation operation) {
        this._operation = operation;
    }

    public void execute(IDatabaseConnection connection, IDataSet dataSet) throws DatabaseUnitException, SQLException {
        IDatabaseConnection databaseConnection = connection;
        Connection jdbcConnection = databaseConnection.getConnection();
        if (!jdbcConnection.getAutoCommit()) {
            throw new ExclusiveTransactionException();
        }
        jdbcConnection.setAutoCommit(false);
        try {
            this._operation.execute(databaseConnection, dataSet);
            jdbcConnection.commit();
        }
        catch (DatabaseUnitException e) {
            jdbcConnection.rollback();
            throw e;
        }
        catch (SQLException e) {
            jdbcConnection.rollback();
            throw e;
        }
        catch (RuntimeException e) {
            jdbcConnection.rollback();
            throw e;
        }
        finally {
            jdbcConnection.setAutoCommit(true);
        }
    }
}

