/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.util.UrlPathHelper;

public abstract class AbstractUrlViewController
extends AbstractController {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();

    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.urlPathHelper.setAlwaysUseFullPath(alwaysUseFullPath);
    }

    public void setUrlDecode(boolean urlDecode) {
        this.urlPathHelper.setUrlDecode(urlDecode);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        this.urlPathHelper = urlPathHelper;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) {
        String urlPath = this.urlPathHelper.getLookupPathForRequest(request);
        String viewName = this.getViewNameForUrlPath(urlPath);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Returning view name '" + viewName + "' for lookup path: " + urlPath));
        }
        return new ModelAndView(viewName);
    }

    protected abstract String getViewNameForUrlPath(String var1);
}

