/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acl.basic;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import org.acegisecurity.Authentication;
import org.acegisecurity.acl.AclEntry;
import org.acegisecurity.acl.AclProvider;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.AclObjectIdentityAware;
import org.acegisecurity.acl.basic.BasicAclDao;
import org.acegisecurity.acl.basic.BasicAclEntry;
import org.acegisecurity.acl.basic.BasicAclEntryCache;
import org.acegisecurity.acl.basic.EffectiveAclsResolver;
import org.acegisecurity.acl.basic.GrantedAuthorityEffectiveAclsResolver;
import org.acegisecurity.acl.basic.SimpleAclEntry;
import org.acegisecurity.acl.basic.cache.NullAclEntryCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class BasicAclProvider
implements AclProvider,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$acl$basic$BasicAclProvider == null ? (class$org$acegisecurity$acl$basic$BasicAclProvider = BasicAclProvider.class$("org.acegisecurity.acl.basic.BasicAclProvider")) : class$org$acegisecurity$acl$basic$BasicAclProvider));
    private static String RECIPIENT_FOR_CACHE_EMPTY = "RESERVED_RECIPIENT_NOBODY";
    private BasicAclDao basicAclDao;
    private BasicAclEntryCache basicAclEntryCache = new NullAclEntryCache();
    private Class defaultAclObjectIdentityClass = class$org$acegisecurity$acl$basic$NamedEntityObjectIdentity == null ? (class$org$acegisecurity$acl$basic$NamedEntityObjectIdentity = BasicAclProvider.class$("org.acegisecurity.acl.basic.NamedEntityObjectIdentity")) : class$org$acegisecurity$acl$basic$NamedEntityObjectIdentity;
    private Class restrictSupportToClass = null;
    private EffectiveAclsResolver effectiveAclsResolver = new GrantedAuthorityEffectiveAclsResolver();
    static /* synthetic */ Class class$org$acegisecurity$acl$basic$BasicAclProvider;
    static /* synthetic */ Class class$org$acegisecurity$acl$basic$NamedEntityObjectIdentity;
    static /* synthetic */ Class class$org$acegisecurity$acl$basic$AclObjectIdentity;
    static /* synthetic */ Class class$java$lang$Object;

    public AclEntry[] getAcls(Object domainInstance) {
        BasicAclEntry[] instanceAclEntries;
        HashMap<Object, BasicAclEntry> map = new HashMap<Object, BasicAclEntry>();
        AclObjectIdentity aclIdentity = this.obtainIdentity(domainInstance);
        Assert.notNull((Object)aclIdentity, (String)"domainInstance is not supported by this provider");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looking up: " + aclIdentity.toString()));
        }
        if ((instanceAclEntries = this.lookup(aclIdentity)) == null) {
            return null;
        }
        for (int i = 0; i < instanceAclEntries.length; ++i) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Explicit add: " + instanceAclEntries[i].toString()));
            }
            map.put(instanceAclEntries[i].getRecipient(), instanceAclEntries[i]);
        }
        AclObjectIdentity parent = instanceAclEntries[0].getAclObjectParentIdentity();
        while (parent != null) {
            BasicAclEntry[] parentAclEntries = this.lookup(parent);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Parent lookup: " + parent.toString()));
            }
            if (parentAclEntries == null) {
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)"Parent could not be found in ACL repository");
                break;
            }
            for (int i = 0; i < parentAclEntries.length; ++i) {
                if (!map.containsKey(parentAclEntries[i].getRecipient())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Added parent to map: " + parentAclEntries[i].toString()));
                    }
                    map.put(parentAclEntries[i].getRecipient(), parentAclEntries[i]);
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Did NOT add parent to map: " + parentAclEntries[i].toString()));
            }
            parent = parentAclEntries[0].getAclObjectParentIdentity();
        }
        Collection collection = map.values();
        return collection.toArray(new AclEntry[0]);
    }

    public AclEntry[] getAcls(Object domainInstance, Authentication authentication) {
        AclEntry[] allAcls = this.getAcls(domainInstance);
        return this.effectiveAclsResolver.resolveEffectiveAcls(allAcls, authentication);
    }

    public void setBasicAclDao(BasicAclDao basicAclDao) {
        this.basicAclDao = basicAclDao;
    }

    public BasicAclDao getBasicAclDao() {
        return this.basicAclDao;
    }

    public void setBasicAclEntryCache(BasicAclEntryCache basicAclEntryCache) {
        this.basicAclEntryCache = basicAclEntryCache;
    }

    public BasicAclEntryCache getBasicAclEntryCache() {
        return this.basicAclEntryCache;
    }

    public void setDefaultAclObjectIdentityClass(Class defaultAclObjectIdentityClass) {
        this.defaultAclObjectIdentityClass = defaultAclObjectIdentityClass;
    }

    public Class getDefaultAclObjectIdentityClass() {
        return this.defaultAclObjectIdentityClass;
    }

    public void setEffectiveAclsResolver(EffectiveAclsResolver effectiveAclsResolver) {
        this.effectiveAclsResolver = effectiveAclsResolver;
    }

    public EffectiveAclsResolver getEffectiveAclsResolver() {
        return this.effectiveAclsResolver;
    }

    public void setRestrictSupportToClass(Class restrictSupportToClass) {
        this.restrictSupportToClass = restrictSupportToClass;
    }

    public Class getRestrictSupportToClass() {
        return this.restrictSupportToClass;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.basicAclDao, (String)"basicAclDao required");
        Assert.notNull((Object)this.basicAclEntryCache, (String)"basicAclEntryCache required");
        Assert.notNull((Object)this.basicAclEntryCache, (String)"basicAclEntryCache required");
        Assert.notNull((Object)this.effectiveAclsResolver, (String)"effectiveAclsResolver required");
        Assert.notNull((Object)this.defaultAclObjectIdentityClass, (String)"defaultAclObjectIdentityClass required");
        Assert.isTrue((boolean)(class$org$acegisecurity$acl$basic$AclObjectIdentity == null ? (class$org$acegisecurity$acl$basic$AclObjectIdentity = BasicAclProvider.class$("org.acegisecurity.acl.basic.AclObjectIdentity")) : class$org$acegisecurity$acl$basic$AclObjectIdentity).isAssignableFrom(this.defaultAclObjectIdentityClass), (String)"defaultAclObjectIdentityClass must implement AclObjectIdentity");
        try {
            Constructor constructor = this.defaultAclObjectIdentityClass.getConstructor(class$java$lang$Object == null ? (class$java$lang$Object = BasicAclProvider.class$("java.lang.Object")) : class$java$lang$Object);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("defaultAclObjectIdentityClass must provide a constructor that accepts the domain object instance!");
        }
    }

    public boolean supports(Object domainInstance) {
        if (domainInstance == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"domainInstance is null");
            }
            return false;
        }
        if (this.restrictSupportToClass != null && !this.restrictSupportToClass.isAssignableFrom(domainInstance.getClass())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("domainInstance not instance of " + this.restrictSupportToClass));
            }
            return false;
        }
        if (this.obtainIdentity(domainInstance) == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"obtainIdentity returned null");
            }
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("obtainIdentity returned " + this.obtainIdentity(domainInstance)));
        }
        return true;
    }

    protected AclObjectIdentity obtainIdentity(Object domainInstance) {
        if (domainInstance instanceof AclObjectIdentityAware) {
            AclObjectIdentityAware aclObjectIdentityAware = (AclObjectIdentityAware)domainInstance;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("domainInstance: " + domainInstance + " cast to AclObjectIdentityAware"));
            }
            return aclObjectIdentityAware.getAclObjectIdentity();
        }
        try {
            Constructor constructor = this.defaultAclObjectIdentityClass.getConstructor(class$java$lang$Object == null ? (class$java$lang$Object = BasicAclProvider.class$("java.lang.Object")) : class$java$lang$Object);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("domainInstance: " + domainInstance + " attempting to pass to constructor: " + constructor));
            }
            return (AclObjectIdentity)constructor.newInstance(domainInstance);
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Error attempting construction of " + this.defaultAclObjectIdentityClass + ": " + ex.getMessage()), (Throwable)ex);
                if (ex.getCause() != null) {
                    logger.debug((Object)("Cause: " + ex.getCause().getMessage()), ex.getCause());
                }
            }
            return null;
        }
    }

    private BasicAclEntry[] lookup(AclObjectIdentity aclObjectIdentity) {
        BasicAclEntry[] result = this.basicAclEntryCache.getEntriesFromCache(aclObjectIdentity);
        if (result != null) {
            if (result[0].getRecipient().equals(RECIPIENT_FOR_CACHE_EMPTY)) {
                return null;
            }
            return result;
        }
        result = this.basicAclDao.getAcls(aclObjectIdentity);
        if (result == null) {
            BasicAclEntry[] emptyAclEntries = new SimpleAclEntry[]{new SimpleAclEntry(RECIPIENT_FOR_CACHE_EMPTY, aclObjectIdentity, null, 0)};
            this.basicAclEntryCache.putEntriesInCache(emptyAclEntries);
            return null;
        }
        this.basicAclEntryCache.putEntriesInCache(result);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

