/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.util.NumberUtils;

public class SingleColumnRowMapper
implements RowMapper {
    private Class requiredType;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Clob;

    public SingleColumnRowMapper() {
    }

    public SingleColumnRowMapper(Class requiredType) {
        this.requiredType = requiredType;
    }

    public void setRequiredType(Class requiredType) {
        this.requiredType = requiredType;
    }

    public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int nrOfColumns = rsmd.getColumnCount();
        if (nrOfColumns != 1) {
            throw new IncorrectResultSetColumnCountException(1, nrOfColumns);
        }
        Object result = this.getColumnValue(rs, 1, this.requiredType);
        if (result != null && this.requiredType != null && !this.requiredType.isInstance(result)) {
            try {
                return this.convertValueToRequiredType(result, this.requiredType);
            }
            catch (IllegalArgumentException ex) {
                throw new TypeMismatchDataAccessException("Type mismatch affecting row number " + rowNum + " and column type '" + rsmd.getColumnTypeName(1) + "': " + ex.getMessage());
            }
        }
        return result;
    }

    protected Object getColumnValue(ResultSet rs, int index, Class requiredType) throws SQLException {
        if (requiredType != null) {
            Object value = null;
            boolean wasNullCheck = false;
            if ((class$java$lang$String == null ? (class$java$lang$String = SingleColumnRowMapper.class$("java.lang.String")) : class$java$lang$String).equals(requiredType)) {
                value = rs.getString(index);
            } else if ((class$java$lang$Boolean == null ? (class$java$lang$Boolean = SingleColumnRowMapper.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(requiredType)) {
                value = rs.getBoolean(index) ? Boolean.TRUE : Boolean.FALSE;
                wasNullCheck = true;
            } else if ((class$java$lang$Byte == null ? (class$java$lang$Byte = SingleColumnRowMapper.class$("java.lang.Byte")) : class$java$lang$Byte).equals(requiredType)) {
                value = new Byte(rs.getByte(index));
                wasNullCheck = true;
            } else if ((class$java$lang$Short == null ? (class$java$lang$Short = SingleColumnRowMapper.class$("java.lang.Short")) : class$java$lang$Short).equals(requiredType)) {
                value = new Short(rs.getShort(index));
                wasNullCheck = true;
            } else if ((class$java$lang$Integer == null ? (class$java$lang$Integer = SingleColumnRowMapper.class$("java.lang.Integer")) : class$java$lang$Integer).equals(requiredType)) {
                value = new Integer(rs.getInt(index));
                wasNullCheck = true;
            } else if ((class$java$lang$Long == null ? (class$java$lang$Long = SingleColumnRowMapper.class$("java.lang.Long")) : class$java$lang$Long).equals(requiredType)) {
                value = new Long(rs.getLong(index));
                wasNullCheck = true;
            } else if ((class$java$lang$Float == null ? (class$java$lang$Float = SingleColumnRowMapper.class$("java.lang.Float")) : class$java$lang$Float).equals(requiredType)) {
                value = new Float(rs.getFloat(index));
                wasNullCheck = true;
            } else if ((class$java$lang$Double == null ? (class$java$lang$Double = SingleColumnRowMapper.class$("java.lang.Double")) : class$java$lang$Double).equals(requiredType) || (class$java$lang$Number == null ? (class$java$lang$Number = SingleColumnRowMapper.class$("java.lang.Number")) : class$java$lang$Number).equals(requiredType)) {
                value = new Double(rs.getDouble(index));
                wasNullCheck = true;
            } else {
                value = (array$B == null ? (array$B = SingleColumnRowMapper.class$("[B")) : array$B).equals(requiredType) ? (Object)rs.getBytes(index) : ((class$java$sql$Date == null ? (class$java$sql$Date = SingleColumnRowMapper.class$("java.sql.Date")) : class$java$sql$Date).equals(requiredType) ? rs.getDate(index) : ((class$java$sql$Time == null ? (class$java$sql$Time = SingleColumnRowMapper.class$("java.sql.Time")) : class$java$sql$Time).equals(requiredType) ? rs.getTime(index) : ((class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = SingleColumnRowMapper.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).equals(requiredType) || (class$java$util$Date == null ? (class$java$util$Date = SingleColumnRowMapper.class$("java.util.Date")) : class$java$util$Date).equals(requiredType) ? rs.getTimestamp(index) : ((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SingleColumnRowMapper.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).equals(requiredType) ? rs.getBigDecimal(index) : ((class$java$sql$Blob == null ? (class$java$sql$Blob = SingleColumnRowMapper.class$("java.sql.Blob")) : class$java$sql$Blob).equals(requiredType) ? rs.getBlob(index) : ((class$java$sql$Clob == null ? (class$java$sql$Clob = SingleColumnRowMapper.class$("java.sql.Clob")) : class$java$sql$Clob).equals(requiredType) ? rs.getClob(index) : rs.getObject(index)))))));
            }
            if (wasNullCheck && value != null && rs.wasNull()) {
                value = null;
            }
            return value;
        }
        return this.getColumnValue(rs, index);
    }

    protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
        return JdbcUtils.getResultSetValue(rs, index);
    }

    protected Object convertValueToRequiredType(Object value, Class requiredType) {
        if ((class$java$lang$String == null ? (class$java$lang$String = SingleColumnRowMapper.class$("java.lang.String")) : class$java$lang$String).equals(this.requiredType)) {
            return value.toString();
        }
        if ((class$java$lang$Number == null ? (class$java$lang$Number = SingleColumnRowMapper.class$("java.lang.Number")) : class$java$lang$Number).isAssignableFrom(this.requiredType)) {
            if (value instanceof Number) {
                return NumberUtils.convertNumberToTargetClass((Number)((Number)value), (Class)this.requiredType);
            }
            return NumberUtils.parseNumber((String)value.toString(), (Class)this.requiredType);
        }
        throw new IllegalArgumentException("Value [" + value + "] is of type [" + value.getClass().getName() + "] and cannot be converted to required type [" + this.requiredType.getName() + "]");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

