/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.AbstractFormTag;
import org.springframework.web.servlet.tags.form.SelectedValueComparator;
import org.springframework.web.servlet.tags.form.TagWriter;
import org.springframework.web.util.TagUtils;

public class OptionTag
extends AbstractFormTag {
    private String value;
    private String label;
    static /* synthetic */ Class class$org$springframework$web$servlet$tags$form$SelectTag;

    public void setValue(String value) {
        Assert.notNull((Object)value, (String)"'value' cannot be null.");
        this.value = value;
    }

    protected String getValue() {
        return this.value;
    }

    public void setLabel(String label) {
        Assert.notNull((Object)label, (String)"'label' cannot be null.");
        this.label = label;
    }

    protected String getLabel() {
        return this.label;
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        this.assertUnderSelectTag();
        tagWriter.startTag("option");
        Object resolvedValue = this.evaluate("value", this.getValue());
        tagWriter.writeAttribute("value", ObjectUtils.getDisplayString((Object)resolvedValue));
        if (this.isSelected(resolvedValue)) {
            tagWriter.writeAttribute("selected", "true");
        }
        tagWriter.appendValue(this.getLabelValue(resolvedValue));
        tagWriter.endTag();
        return 6;
    }

    private void assertUnderSelectTag() {
        if (!TagUtils.hasAncestorOfType((Tag)this, (Class)(class$org$springframework$web$servlet$tags$form$SelectTag == null ? (class$org$springframework$web$servlet$tags$form$SelectTag = OptionTag.class$("org.springframework.web.servlet.tags.form.SelectTag")) : class$org$springframework$web$servlet$tags$form$SelectTag))) {
            throw new IllegalStateException("The 'option' tag can only be used inside a valid 'select' tag.");
        }
    }

    private boolean isSelected(Object resolvedValue) {
        return SelectedValueComparator.isSelected(this.getBindStatus(), resolvedValue);
    }

    private String getLabelValue(Object resolvedValue) throws JspException {
        String label = this.getLabel();
        Object labelObj = label == null ? resolvedValue : this.evaluate("label", label);
        return ObjectUtils.getDisplayString((Object)labelObj);
    }

    private BindStatus getBindStatus() {
        return (BindStatus)this.pageContext.getAttribute("org.springframework.web.servlet.tags.form.SelectTag.listValue");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

