/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dtd;

import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.dtd.ModelNode;
import com.ctc.wstx.dtd.NameKey;
import com.ctc.wstx.dtd.NameKeySet;
import com.ctc.wstx.dtd.StructValidator;
import java.util.BitSet;
import java.util.List;

public class ChoiceModel
extends ModelNode {
    final ModelNode[] mSubModels;
    boolean mNullable = false;
    BitSet mFirstPos;
    BitSet mLastPos;

    protected ChoiceModel(ModelNode[] subModels) {
        this.mSubModels = subModels;
        boolean nullable = false;
        int len = subModels.length;
        for (int i = 0; i < len; ++i) {
            if (!subModels[i].isNullable()) continue;
            nullable = true;
            break;
        }
        this.mNullable = nullable;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.mSubModels.length; ++i) {
            if (i > 0) {
                sb.append(" | ");
            }
            sb.append(this.mSubModels[i].toString());
        }
        sb.append(')');
        return sb.toString();
    }

    public ModelNode cloneModel() {
        int len = this.mSubModels.length;
        ModelNode[] newModels = new ModelNode[len];
        for (int i = 0; i < len; ++i) {
            newModels[i] = this.mSubModels[i].cloneModel();
        }
        return new ChoiceModel(newModels);
    }

    public boolean isNullable() {
        return this.mNullable;
    }

    public void indexTokens(List tokens) {
        int len = this.mSubModels.length;
        for (int i = 0; i < len; ++i) {
            this.mSubModels[i].indexTokens(tokens);
        }
    }

    public void addFirstPos(BitSet firstPos) {
        if (this.mFirstPos == null) {
            this.mFirstPos = new BitSet();
            int len = this.mSubModels.length;
            for (int i = 0; i < len; ++i) {
                this.mSubModels[i].addFirstPos(this.mFirstPos);
            }
        }
        firstPos.or(this.mFirstPos);
    }

    public void addLastPos(BitSet lastPos) {
        if (this.mLastPos == null) {
            this.mLastPos = new BitSet();
            int len = this.mSubModels.length;
            for (int i = 0; i < len; ++i) {
                this.mSubModels[i].addLastPos(this.mLastPos);
            }
        }
        lastPos.or(this.mLastPos);
    }

    public void calcFollowPos(BitSet[] followPosSets) {
        int len = this.mSubModels.length;
        for (int i = 0; i < len; ++i) {
            this.mSubModels[i].calcFollowPos(followPosSets);
        }
    }

    static final class Validator
    extends StructValidator {
        final char mArity;
        final NameKeySet mNames;
        int mCount = 0;

        public Validator(char arity, NameKeySet names) {
            this.mArity = arity;
            this.mNames = names;
        }

        public StructValidator newInstance() {
            return this.mArity == '*' ? this : new Validator(this.mArity, this.mNames);
        }

        public String tryToValidate(NameKey elemName) {
            if (this.mNames == null) {
                return ErrorConsts.ERR_INTERNAL;
            }
            if (!this.mNames.contains(elemName)) {
                if (this.mNames.hasMultiple()) {
                    return "Expected one of (" + this.mNames.toString(" | ") + ")";
                }
                return "Expected <" + this.mNames.toString("") + ">";
            }
            if (++this.mCount > 1) {
                if (this.mArity == '?') {
                    if (this.mNames.hasMultiple()) {
                        return "More than one instance; expected at most one of (" + this.mNames.toString(" | ") + ")";
                    }
                    return "More than one instance; expected at most one";
                }
                if (this.mArity == ' ') {
                    if (this.mNames.hasMultiple()) {
                        return "More than one instance; expected exactly one of (" + this.mNames.toString(" | ") + ")";
                    }
                    return "More than one instance; expected exactly one";
                }
            }
            return null;
        }

        public String fullyValid() {
            switch (this.mArity) {
                case '*': 
                case '?': {
                    return null;
                }
                case ' ': 
                case '+': {
                    if (this.mCount > 0) {
                        return null;
                    }
                    return "Expected " + (this.mArity == '+' ? "at least" : "") + " one of elements (" + this.mNames + ")";
                }
            }
            throw new Error("Internal error");
        }
    }
}

