/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.io.Serializable;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tuple.ComponentTuplizer;
import org.hibernate.tuple.Dom4jComponentTuplizer;
import org.hibernate.tuple.Dom4jEntityTuplizer;
import org.hibernate.tuple.DynamicMapComponentTuplizer;
import org.hibernate.tuple.DynamicMapEntityTuplizer;
import org.hibernate.tuple.EntityMetamodel;
import org.hibernate.tuple.EntityTuplizer;
import org.hibernate.tuple.PojoComponentTuplizer;
import org.hibernate.tuple.PojoEntityTuplizer;
import org.hibernate.tuple.Tuplizer;
import org.hibernate.util.ReflectHelper;

public class TuplizerLookup
implements Serializable {
    private static final Class[] ENTITY_TUP_CTOR_SIG = new Class[]{EntityMetamodel.class, PersistentClass.class};
    private static final Class[] COMPONENT_TUP_CTOR_SIG = new Class[]{Component.class};
    private final Tuplizer pojoTuplizer;
    private final Tuplizer dynamicMapTuplizer;
    private final Tuplizer dom4jTuplizer;

    private TuplizerLookup(Tuplizer pojoTuplizer, Tuplizer dynamicMapTuplizer, Tuplizer dom4jTuplizer) {
        this.pojoTuplizer = pojoTuplizer;
        this.dynamicMapTuplizer = dynamicMapTuplizer;
        this.dom4jTuplizer = dom4jTuplizer;
    }

    public static TuplizerLookup create(PersistentClass mappedEntity, EntityMetamodel em) {
        EntityTuplizer dynamicMapTuplizer = null;
        String tuplizerImpl = mappedEntity.getTuplizerImplClassName(EntityMode.MAP);
        dynamicMapTuplizer = tuplizerImpl == null ? new DynamicMapEntityTuplizer(em, mappedEntity) : TuplizerLookup.buildEntityTuplizer(tuplizerImpl, mappedEntity, em);
        EntityTuplizer pojoTuplizer = null;
        pojoTuplizer = mappedEntity.hasPojoRepresentation() ? ((tuplizerImpl = mappedEntity.getTuplizerImplClassName(EntityMode.POJO)) == null ? new PojoEntityTuplizer(em, mappedEntity) : TuplizerLookup.buildEntityTuplizer(tuplizerImpl, mappedEntity, em)) : dynamicMapTuplizer;
        EntityTuplizer dom4jTuplizer = null;
        dom4jTuplizer = mappedEntity.hasDom4jRepresentation() ? ((tuplizerImpl = mappedEntity.getTuplizerImplClassName(EntityMode.DOM4J)) == null ? new Dom4jEntityTuplizer(em, mappedEntity) : TuplizerLookup.buildEntityTuplizer(tuplizerImpl, mappedEntity, em)) : null;
        return new TuplizerLookup(pojoTuplizer, dynamicMapTuplizer, dom4jTuplizer);
    }

    private static EntityTuplizer buildEntityTuplizer(String className, PersistentClass pc, EntityMetamodel em) {
        try {
            Class implClass = ReflectHelper.classForName(className);
            return (EntityTuplizer)implClass.getConstructor(ENTITY_TUP_CTOR_SIG).newInstance(em, pc);
        }
        catch (Throwable t) {
            throw new HibernateException("Could not build tuplizer [" + className + "]", t);
        }
    }

    public static TuplizerLookup create(Component component) {
        PersistentClass owner = component.getOwner();
        ComponentTuplizer dynamicMapTuplizer = null;
        String tuplizerImpl = component.getTuplizerImplClassName(EntityMode.MAP);
        dynamicMapTuplizer = tuplizerImpl == null ? new DynamicMapComponentTuplizer(component) : TuplizerLookup.buildComponentTuplizer(tuplizerImpl, component);
        ComponentTuplizer pojoTuplizer = null;
        pojoTuplizer = owner.hasPojoRepresentation() && component.hasPojoRepresentation() ? ((tuplizerImpl = component.getTuplizerImplClassName(EntityMode.POJO)) == null ? new PojoComponentTuplizer(component) : TuplizerLookup.buildComponentTuplizer(tuplizerImpl, component)) : dynamicMapTuplizer;
        ComponentTuplizer dom4jTuplizer = null;
        dom4jTuplizer = owner.hasDom4jRepresentation() ? ((tuplizerImpl = component.getTuplizerImplClassName(EntityMode.DOM4J)) == null ? new Dom4jComponentTuplizer(component) : TuplizerLookup.buildComponentTuplizer(tuplizerImpl, component)) : null;
        return new TuplizerLookup(pojoTuplizer, dynamicMapTuplizer, dom4jTuplizer);
    }

    private static ComponentTuplizer buildComponentTuplizer(String tuplizerImpl, Component component) {
        try {
            Class implClass = ReflectHelper.classForName(tuplizerImpl);
            return (ComponentTuplizer)implClass.getConstructor(COMPONENT_TUP_CTOR_SIG).newInstance(component);
        }
        catch (Throwable t) {
            throw new HibernateException("Could not build tuplizer [" + tuplizerImpl + "]", t);
        }
    }

    public EntityMode guessEntityMode(Object object) {
        if (this.pojoTuplizer != null && this.pojoTuplizer.isInstance(object)) {
            return EntityMode.POJO;
        }
        if (this.dom4jTuplizer != null && this.dom4jTuplizer.isInstance(object)) {
            return EntityMode.DOM4J;
        }
        if (this.dynamicMapTuplizer != null && this.dynamicMapTuplizer.isInstance(object)) {
            return EntityMode.MAP;
        }
        return null;
    }

    public Tuplizer getTuplizerOrNull(EntityMode entityMode) {
        Tuplizer rtn = null;
        if (EntityMode.POJO == entityMode) {
            rtn = this.pojoTuplizer;
        } else if (EntityMode.DOM4J == entityMode) {
            rtn = this.dom4jTuplizer;
        } else if (EntityMode.MAP == entityMode) {
            rtn = this.dynamicMapTuplizer;
        }
        return rtn;
    }

    public Tuplizer getTuplizer(EntityMode entityMode) {
        Tuplizer rtn = this.getTuplizerOrNull(entityMode);
        if (rtn == null) {
            throw new HibernateException("No tuplizer found for entity-mode [" + entityMode + "]");
        }
        return rtn;
    }
}

