/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTable;
import org.dbunit.dataset.DefaultTableIterator;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchTableException;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.dbunit.dataset.xml.FlatDtdProducer;
import org.dbunit.dataset.xml.FlatDtdWriter;
import org.xml.sax.InputSource;

public class FlatDtdDataSet
extends AbstractDataSet
implements IDataSetConsumer {
    private final List _tableNames = new ArrayList();
    private final Map _tableMap = new HashMap();
    private boolean _ready = false;

    public FlatDtdDataSet() {
    }

    public FlatDtdDataSet(InputStream in) throws DataSetException, IOException {
        this(new FlatDtdProducer(new InputSource(in)));
    }

    public FlatDtdDataSet(Reader reader) throws DataSetException, IOException {
        this(new FlatDtdProducer(new InputSource(reader)));
    }

    public FlatDtdDataSet(IDataSetProducer producer) throws DataSetException {
        producer.setConsumer(this);
        producer.produce();
    }

    public static void write(IDataSet dataSet, OutputStream out) throws IOException, DataSetException {
        FlatDtdDataSet.write(dataSet, new OutputStreamWriter(out));
    }

    public static void write(IDataSet dataSet, Writer out) throws IOException, DataSetException {
        FlatDtdWriter datasetWriter = new FlatDtdWriter(out);
        datasetWriter.write(dataSet);
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        if (!this._ready) {
            throw new IllegalStateException("Not ready!");
        }
        String[] names = this._tableNames.toArray(new String[0]);
        ITable[] tables = new ITable[names.length];
        for (int i = 0; i < names.length; ++i) {
            String tableName = names[i];
            ITable table = (ITable)this._tableMap.get(tableName);
            if (table == null) {
                throw new NoSuchTableException(tableName);
            }
            tables[i] = table;
        }
        return new DefaultTableIterator(tables, reversed);
    }

    public String[] getTableNames() throws DataSetException {
        if (!this._ready) {
            throw new IllegalStateException("Not ready!");
        }
        return this._tableNames.toArray(new String[0]);
    }

    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        if (!this._ready) {
            throw new IllegalStateException("Not ready!");
        }
        String upperTableName = tableName.toUpperCase();
        if (this._tableMap.containsKey(upperTableName)) {
            ITable table = (ITable)this._tableMap.get(upperTableName);
            return table.getTableMetaData();
        }
        throw new NoSuchTableException(tableName);
    }

    public ITable getTable(String tableName) throws DataSetException {
        if (!this._ready) {
            throw new IllegalStateException("Not ready!");
        }
        String upperTableName = tableName.toUpperCase();
        if (this._tableMap.containsKey(upperTableName)) {
            return (ITable)this._tableMap.get(upperTableName);
        }
        throw new NoSuchTableException(tableName);
    }

    public void startDataSet() throws DataSetException {
        this._ready = false;
    }

    public void endDataSet() throws DataSetException {
        this._ready = true;
    }

    public void startTable(ITableMetaData metaData) throws DataSetException {
        String tableName = metaData.getTableName();
        this._tableNames.add(tableName);
        this._tableMap.put(tableName.toUpperCase(), new DefaultTable(metaData));
    }

    public void endTable() throws DataSetException {
    }

    public void row(Object[] values) throws DataSetException {
    }
}

