/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.xml;

import java.io.PrintWriter;
import java.io.Writer;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;

public class FlatDtdWriter {
    public static final ContentModel SEQUENCE = new SequenceModel();
    public static final ContentModel CHOICE = new ChoiceModel();
    private Writer _writer;
    private ContentModel _contentModel;

    public FlatDtdWriter(Writer writer) {
        this._writer = writer;
        this._contentModel = SEQUENCE;
    }

    public void setContentModel(ContentModel contentModel) {
        this._contentModel = contentModel;
    }

    public void write(IDataSet dataSet) throws DataSetException {
        int i;
        PrintWriter printOut = new PrintWriter(this._writer);
        String[] tableNames = dataSet.getTableNames();
        printOut.print("<!ELEMENT dataset (\n");
        for (i = 0; i < tableNames.length; ++i) {
            this._contentModel.write(printOut, tableNames[i], i, tableNames.length);
        }
        printOut.print(")>\n");
        printOut.print("\n");
        for (i = 0; i < tableNames.length; ++i) {
            String tableName = tableNames[i];
            printOut.print("<!ELEMENT ");
            printOut.print(tableName);
            printOut.print(" EMPTY>\n");
            printOut.print("<!ATTLIST ");
            printOut.print(tableName);
            printOut.print("\n");
            Column[] columns = dataSet.getTableMetaData(tableName).getColumns();
            for (int j = 0; j < columns.length; ++j) {
                Column column = columns[j];
                printOut.print("    ");
                printOut.print(column.getColumnName());
                if (column.getNullable() == Column.NO_NULLS) {
                    printOut.print(" CDATA #REQUIRED\n");
                    continue;
                }
                printOut.print(" CDATA #IMPLIED\n");
            }
            printOut.print(">\n");
            printOut.print("\n");
        }
        printOut.flush();
    }

    public static class ChoiceModel
    extends ContentModel {
        private ChoiceModel() {
            super("sequence");
        }

        public void write(PrintWriter writer, String tableName, int tableIndex, int tableCount) {
            boolean last;
            boolean first = tableIndex == 0;
            boolean bl = last = tableIndex + 1 == tableCount;
            if (first) {
                writer.print("   (");
            } else {
                writer.print("    ");
            }
            writer.print(tableName);
            if (!last) {
                writer.print("|\n");
            } else {
                writer.print(")*");
            }
        }
    }

    public static class SequenceModel
    extends ContentModel {
        private SequenceModel() {
            super("sequence");
        }

        public void write(PrintWriter writer, String tableName, int tableIndex, int tableCount) {
            boolean last = tableIndex + 1 == tableCount;
            writer.print("    ");
            writer.print(tableName);
            writer.print("*");
            if (!last) {
                writer.print(",\n");
            }
        }
    }

    public static abstract class ContentModel {
        private final String _name;

        private ContentModel(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }

        public abstract void write(PrintWriter var1, String var2, int var3, int var4);
    }
}

