/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.concurrent;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public class PropertyChangeMulticaster
implements Serializable {
    protected transient PropertyChangeListener[] listeners = new PropertyChangeListener[0];
    protected final Object source;
    protected HashMap children;

    protected synchronized PropertyChangeMulticaster getChild(String propertyName) {
        return this.children == null ? null : (PropertyChangeMulticaster)this.children.get(propertyName);
    }

    public PropertyChangeMulticaster(Object sourceBean) {
        if (sourceBean == null) {
            throw new NullPointerException();
        }
        this.source = sourceBean;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        int len = this.listeners.length;
        PropertyChangeListener[] newArray = new PropertyChangeListener[len + 1];
        if (len > 0) {
            System.arraycopy(this.listeners, 0, newArray, 0, len);
        }
        newArray[len] = listener;
        this.listeners = newArray;
    }

    public synchronized void addPropertyChangeListenerIfAbsent(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        int len = this.listeners.length;
        PropertyChangeListener[] newArray = new PropertyChangeListener[len + 1];
        for (int i = 0; i < len; ++i) {
            newArray[i] = this.listeners[i];
            if (!listener.equals(this.listeners[i])) continue;
            return;
        }
        newArray[len] = listener;
        this.listeners = newArray;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        int newlen = this.listeners.length - 1;
        if (newlen < 0 || listener == null) {
            return;
        }
        PropertyChangeListener[] newArray = new PropertyChangeListener[newlen];
        for (int i = 0; i < newlen; ++i) {
            if (listener.equals(this.listeners[i])) {
                for (int k = i + 1; k <= newlen; ++k) {
                    newArray[k - 1] = this.listeners[k];
                }
                this.listeners = newArray;
                return;
            }
            newArray[i] = this.listeners[i];
        }
        if (listener.equals(this.listeners[newlen])) {
            this.listeners = newArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        PropertyChangeMulticaster child = null;
        PropertyChangeMulticaster propertyChangeMulticaster = this;
        synchronized (propertyChangeMulticaster) {
            if (this.children == null) {
                this.children = new HashMap();
            } else {
                child = (PropertyChangeMulticaster)this.children.get(propertyName);
            }
            if (child == null) {
                child = new PropertyChangeMulticaster(this.source);
                this.children.put(propertyName, child);
            }
        }
        child.addPropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListenerIfAbsent(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        PropertyChangeMulticaster child = null;
        PropertyChangeMulticaster propertyChangeMulticaster = this;
        synchronized (propertyChangeMulticaster) {
            if (this.children == null) {
                this.children = new HashMap();
            } else {
                child = (PropertyChangeMulticaster)this.children.get(propertyName);
            }
            if (child == null) {
                child = new PropertyChangeMulticaster(this.source);
                this.children.put(propertyName, child);
            }
        }
        child.addPropertyChangeListenerIfAbsent(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PropertyChangeMulticaster child = this.getChild(propertyName);
        if (child != null) {
            child.removePropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void multicast(PropertyChangeEvent evt) {
        PropertyChangeListener[] array;
        PropertyChangeMulticaster child = null;
        PropertyChangeMulticaster propertyChangeMulticaster = this;
        synchronized (propertyChangeMulticaster) {
            array = this.listeners;
            if (this.children != null && evt.getPropertyName() != null) {
                child = (PropertyChangeMulticaster)this.children.get(evt.getPropertyName());
            }
        }
        for (int i = 0; i < array.length; ++i) {
            array[i].propertyChange(evt);
        }
        if (child != null) {
            child.multicast(evt);
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            this.multicast(new PropertyChangeEvent(this.source, propertyName, oldValue, newValue));
        }
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (oldValue != newValue) {
            this.multicast(new PropertyChangeEvent(this.source, propertyName, new Integer(oldValue), new Integer(newValue)));
        }
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.multicast(new PropertyChangeEvent(this.source, propertyName, new Boolean(oldValue), new Boolean(newValue)));
        }
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            this.multicast(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners(String propertyName) {
        PropertyChangeMulticaster child;
        PropertyChangeMulticaster propertyChangeMulticaster = this;
        synchronized (propertyChangeMulticaster) {
            if (this.listeners.length > 0) {
                return true;
            }
            if (propertyName == null || this.children == null) {
                return false;
            }
            child = (PropertyChangeMulticaster)this.children.get(propertyName);
            if (child == null) {
                return false;
            }
        }
        return child.hasListeners(null);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        for (int i = 0; i < this.listeners.length; ++i) {
            if (!(this.listeners[i] instanceof Serializable)) continue;
            s.writeObject(this.listeners[i]);
        }
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        Object listenerOrNull;
        this.listeners = new PropertyChangeListener[0];
        s.defaultReadObject();
        while (null != (listenerOrNull = s.readObject())) {
            this.addPropertyChangeListener((PropertyChangeListener)listenerOrNull);
        }
    }
}

