/*
 * Decompiled with CFR 0.152.
 */
package net.sf.navigator.displayer;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import net.sf.navigator.displayer.MenuDisplayerMapping;
import net.sf.navigator.displayer.MessageResourcesMenuDisplayer;
import net.sf.navigator.menu.MenuComponent;
import org.apache.commons.lang.StringUtils;

public class ListMenuDisplayer
extends MessageResourcesMenuDisplayer {
    public void init(PageContext pageContext, MenuDisplayerMapping mapping) {
        super.init(pageContext, mapping);
        try {
            this.out.println(this.displayStrings.getMessage("lmd.begin"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void display(MenuComponent menu) throws JspException, IOException {
        if (this.isAllowed(menu)) {
            this.out.println(this.displayStrings.getMessage("lmd.menu.top"));
            this.displayComponents(menu, 0);
            this.out.println(this.displayStrings.getMessage("lmd.menu.bottom"));
        }
    }

    protected void displayComponents(MenuComponent menu, int level) throws JspException, IOException {
        String title = super.getMessage(menu.getTitle());
        MenuComponent[] components = menu.getMenuComponents();
        if (components.length > 0) {
            String domId = StringUtils.deleteWhitespace((String)this.getMessage(menu.getTitle()));
            String menuClass = "menu";
            if (level >= 1) {
                menuClass = "submenu";
            }
            if (menu.getUrl() != null) {
                this.out.println(this.displayStrings.getMessage("lmd.menu.actuator.link", (Object)domId, (Object)this.getMessage(menu.getTitle()), (Object)menuClass, (Object)this.getMessage(menu.getUrl())));
            } else {
                this.out.println(this.displayStrings.getMessage("lmd.menu.actuator.top", (Object)domId, (Object)this.getMessage(menu.getTitle()), (Object)menuClass));
            }
            for (int i = 0; i < components.length; ++i) {
                if (!this.isAllowed(components[i])) continue;
                if (components[i].getMenuComponents().length > 0) {
                    this.out.println("<li>");
                    this.displayComponents(components[i], level + 1);
                    this.out.println(this.displayStrings.getMessage("lmd.menu.actuator.bottom"));
                    if (i != components[i].getMenuComponents().length - 1) continue;
                    this.out.println("</li>");
                    continue;
                }
                this.out.println(this.displayStrings.getMessage("lmd.menu.item", (Object)components[i].getUrl(), (Object)super.getMenuToolTip(components[i]), (Object)this.getExtra(components[i]), (Object)this.getMessage(components[i].getTitle())));
            }
            if (menuClass.equals("menu")) {
                this.out.println("</ul>");
            }
        } else if (menu.getParent() == null) {
            this.out.println(this.displayStrings.getMessage("lmd.menu.standalone", (Object)menu.getUrl(), (Object)super.getMenuToolTip(menu), (Object)this.getExtra(menu), (Object)this.getMessage(menu.getTitle())));
        } else {
            this.out.println(this.displayStrings.getMessage("lmd.menu.item", (Object)menu.getUrl(), (Object)super.getMenuToolTip(menu), (Object)this.getExtra(menu), (Object)this.getMessage(menu.getTitle())));
        }
    }

    public void end(PageContext context) {
        try {
            this.out.print(this.displayStrings.getMessage("lmd.end"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getExtra(MenuComponent menu) {
        StringBuffer extra = new StringBuffer();
        if (menu.getTarget() != null) {
            extra.append(" target=\"" + menu.getTarget() + "\"");
        }
        if (menu.getOnclick() != null) {
            extra.append(" onclick=\"" + menu.getOnclick() + "\"");
        }
        return extra.length() > 0 ? extra.toString() : "";
    }
}

