/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.collections.LRUMap;

public class SimpleMRUCache
implements Serializable {
    public static final int DEFAULT_STRONG_REF_COUNT = 128;
    private final int strongReferenceCount;
    private transient LRUMap cache;

    public SimpleMRUCache() {
        this(128);
    }

    public SimpleMRUCache(int strongReferenceCount) {
        this.strongReferenceCount = strongReferenceCount;
        this.init();
    }

    public synchronized Object get(Object key) {
        return this.cache.get(key);
    }

    public Object put(Object key, Object value) {
        return this.cache.put(key, value);
    }

    public Iterator entries() {
        return this.cache.entrySet().iterator();
    }

    public int size() {
        return this.cache.size();
    }

    private void init() {
        this.cache = new LRUMap(this.strongReferenceCount);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }
}

