/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.io.BaseReader;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;

public final class AsciiReader
extends BaseReader {
    static final char HIGH_ASCII = '\u007f';
    int mCharCount = 0;

    AsciiReader(InputStream in, byte[] buf, int ptr, int len) {
        super(in, buf, ptr, len);
    }

    public int read(char[] cbuf, int start, int len) throws IOException {
        int avail;
        if (this.mBuffer == null) {
            return -1;
        }
        if (start < 0 || start + len > cbuf.length) {
            this.reportBounds(cbuf, start, len);
        }
        if ((avail = this.mLength - this.mPtr) <= 0) {
            int count = this.mIn.read(this.mBuffer);
            if (count <= 0) {
                if (count == 0) {
                    this.reportStrangeStream();
                }
                this.mBuffer = null;
                return -1;
            }
            this.mLength = avail = count;
            this.mCharCount += count;
            this.mPtr = 0;
        }
        if (len > avail) {
            len = avail;
        }
        int i = this.mPtr;
        int last = i + len;
        while (i < last) {
            char c;
            if ((c = (char)this.mBuffer[i++]) > '\u007f') {
                this.reportInvalidAscii(c);
            }
            cbuf[start++] = c;
        }
        this.mPtr = last;
        return len;
    }

    private void reportInvalidAscii(char c) throws IOException {
        throw new CharConversionException("Invalid ascii byte; value above 7-bit ascii range (" + c + "; at pos #" + (this.mCharCount + this.mPtr) + ")");
    }
}

