/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.acegisecurity.Authentication;
import org.acegisecurity.acl.AclEntry;
import org.acegisecurity.acl.AclManager;
import org.acegisecurity.acl.AclProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class AclProviderManager
implements AclManager,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$acl$AclProviderManager == null ? (class$org$acegisecurity$acl$AclProviderManager = AclProviderManager.class$("org.acegisecurity.acl.AclProviderManager")) : class$org$acegisecurity$acl$AclProviderManager));
    private List providers;
    static /* synthetic */ Class class$org$acegisecurity$acl$AclProviderManager;

    public AclEntry[] getAcls(Object domainInstance) {
        Assert.notNull((Object)domainInstance, (String)"domainInstance is null - violating interface contract");
        Iterator iter = this.providers.iterator();
        while (iter.hasNext()) {
            AclProvider provider = (AclProvider)iter.next();
            if (!provider.supports(domainInstance)) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ACL lookup using " + provider.getClass().getName()));
            }
            return provider.getAcls(domainInstance);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("No AclProvider found for " + domainInstance.toString()));
        }
        return null;
    }

    public AclEntry[] getAcls(Object domainInstance, Authentication authentication) {
        Assert.notNull((Object)domainInstance, (String)"domainInstance is null - violating interface contract");
        Assert.notNull((Object)authentication, (String)"authentication is null - violating interface contract");
        Iterator iter = this.providers.iterator();
        while (iter.hasNext()) {
            AclProvider provider = (AclProvider)iter.next();
            if (provider.supports(domainInstance)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("ACL lookup using " + provider.getClass().getName()));
                }
                return provider.getAcls(domainInstance, authentication);
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Provider " + provider.toString() + " does not support " + domainInstance));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("No AclProvider found for " + domainInstance.toString()));
        }
        return null;
    }

    public void setProviders(List newList) {
        this.checkIfValidList(newList);
        Iterator iter = newList.iterator();
        while (iter.hasNext()) {
            Object currentObject = null;
            try {
                currentObject = iter.next();
                AclProvider attemptToCast = (AclProvider)currentObject;
            }
            catch (ClassCastException cce) {
                throw new IllegalArgumentException("AclProvider " + currentObject.getClass().getName() + " must implement AclProvider");
            }
        }
        this.providers = newList;
    }

    public List getProviders() {
        return this.providers;
    }

    public void afterPropertiesSet() throws Exception {
        this.checkIfValidList(this.providers);
    }

    private void checkIfValidList(List listToCheck) {
        Assert.notEmpty((Collection)listToCheck, (String)"A list of AclManagers is required");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

