/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acl.basic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.springframework.util.Assert;

public class NamedEntityObjectIdentity
implements AclObjectIdentity {
    private String classname;
    private String id;

    public NamedEntityObjectIdentity(String classname, String id) {
        Assert.hasText((String)classname, (String)"classname required");
        Assert.hasText((String)id, (String)"id required");
        this.classname = classname;
        this.id = id;
    }

    protected NamedEntityObjectIdentity() {
        throw new IllegalArgumentException("Cannot use default constructor");
    }

    public NamedEntityObjectIdentity(Object object) throws IllegalAccessException, InvocationTargetException {
        Assert.notNull((Object)object, (String)"object cannot be null");
        this.classname = object.getClass().getName();
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getMethod("getId", new Class[0]);
            Object result = method.invoke(object, new Object[0]);
            this.id = result.toString();
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("Object of class '" + clazz + "' does not provide the required getId() method: " + object);
        }
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (!(arg0 instanceof NamedEntityObjectIdentity)) {
            return false;
        }
        NamedEntityObjectIdentity other = (NamedEntityObjectIdentity)arg0;
        return this.getId().equals(other.getId()) && this.getClassname().equals(other.getClassname());
    }

    public String getClassname() {
        return this.classname;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.classname).append(this.id);
        return sb.toString().hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("[");
        sb.append("Classname: ").append(this.classname);
        sb.append("; Identity: ").append(this.id).append("]");
        return sb.toString();
    }
}

