/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class WebAuthenticationDetails
implements Serializable {
    private String remoteAddress;
    private String sessionId;

    public WebAuthenticationDetails(HttpServletRequest request) {
        this.remoteAddress = request.getRemoteAddr();
        this.sessionId = request.getSession(true).getId();
        this.doPopulateAdditionalInformation(request);
    }

    public WebAuthenticationDetails(HttpServletRequest request, boolean forceSessionCreation) {
        this.remoteAddress = request.getRemoteAddr();
        HttpSession session = request.getSession(forceSessionCreation);
        this.sessionId = session != null ? session.getId() : null;
        this.doPopulateAdditionalInformation(request);
    }

    protected WebAuthenticationDetails() {
        throw new IllegalArgumentException("Cannot use default constructor");
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString() + ": ");
        sb.append("RemoteIpAddress: " + this.getRemoteAddress() + "; ");
        sb.append("SessionId: " + this.getSessionId());
        return sb.toString();
    }

    protected void doPopulateAdditionalInformation(HttpServletRequest request) {
    }
}

