/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.switchuser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.AccountExpiredException;
import org.acegisecurity.AcegiMessageSource;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationCredentialsNotFoundException;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.CredentialsExpiredException;
import org.acegisecurity.DisabledException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.LockedException;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.event.authentication.AuthenticationSwitchUserEvent;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.ui.WebAuthenticationDetails;
import org.acegisecurity.ui.switchuser.SwitchUserGrantedAuthority;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.util.Assert;

public class SwitchUserProcessingFilter
implements Filter,
InitializingBean,
ApplicationEventPublisherAware,
MessageSourceAware {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$ui$switchuser$SwitchUserProcessingFilter == null ? (class$org$acegisecurity$ui$switchuser$SwitchUserProcessingFilter = SwitchUserProcessingFilter.class$("org.acegisecurity.ui.switchuser.SwitchUserProcessingFilter")) : class$org$acegisecurity$ui$switchuser$SwitchUserProcessingFilter));
    public static final String ACEGI_SECURITY_SWITCH_USERNAME_KEY = "j_username";
    public static final String ROLE_PREVIOUS_ADMINISTRATOR = "ROLE_PREVIOUS_ADMINISTRATOR";
    private ApplicationEventPublisher eventPublisher;
    private UserDetailsService userDetailsService;
    protected MessageSourceAccessor messages = AcegiMessageSource.getAccessor();
    private String exitUserUrl = "/j_acegi_exit_user";
    private String switchUserUrl = "/j_acegi_switch_user";
    private String targetUrl;
    static /* synthetic */ Class class$org$acegisecurity$ui$switchuser$SwitchUserProcessingFilter;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletRequest;
    static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.switchUserUrl, (String)"switchUserUrl must be specified");
        Assert.hasLength((String)this.exitUserUrl, (String)"exitUserUrl must be specified");
        Assert.hasLength((String)this.targetUrl, (String)"targetUrl must be specified");
        Assert.notNull((Object)this.userDetailsService, (String)"authenticationDao must be specified");
        Assert.notNull((Object)this.messages, (String)"A message source must be set");
    }

    protected Authentication attemptExitUser(HttpServletRequest request) throws AuthenticationCredentialsNotFoundException {
        Authentication current = SecurityContextHolder.getContext().getAuthentication();
        if (null == current) {
            throw new AuthenticationCredentialsNotFoundException(this.messages.getMessage("SwitchUserProcessingFilter.noCurrentUser", "No current user associated with this request"));
        }
        Authentication original = this.getSourceAuthentication(current);
        if (original == null) {
            logger.error((Object)"Could not find original user Authentication object!");
            throw new AuthenticationCredentialsNotFoundException(this.messages.getMessage("SwitchUserProcessingFilter.noOriginalAuthentication", "Could not find original Authentication object"));
        }
        UserDetails originalUser = null;
        Object obj = original.getPrincipal();
        if (obj != null && obj instanceof UserDetails) {
            originalUser = (UserDetails)obj;
        }
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent((ApplicationEvent)new AuthenticationSwitchUserEvent(current, originalUser));
        }
        return original;
    }

    protected Authentication attemptSwitchUser(HttpServletRequest request) throws AuthenticationException {
        UserDetails targetUser;
        UsernamePasswordAuthenticationToken targetUserRequest = null;
        String username = request.getParameter(ACEGI_SECURITY_SWITCH_USERNAME_KEY);
        if (username == null) {
            username = "";
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempt to switch to user [" + username + "]"));
        }
        if ((targetUser = this.userDetailsService.loadUserByUsername(username)) == null) {
            throw new UsernameNotFoundException(this.messages.getMessage("SwitchUserProcessingFilter.usernameNotFound", new Object[]{username}, "Username {0} not found"));
        }
        if (!targetUser.isAccountNonLocked()) {
            throw new LockedException(this.messages.getMessage("SwitchUserProcessingFilter.locked", "User account is locked"));
        }
        if (!targetUser.isEnabled()) {
            throw new DisabledException(this.messages.getMessage("SwitchUserProcessingFilter.disabled", "User is disabled"));
        }
        if (!targetUser.isAccountNonExpired()) {
            throw new AccountExpiredException(this.messages.getMessage("SwitchUserProcessingFilter.expired", "User account has expired"));
        }
        if (!targetUser.isCredentialsNonExpired()) {
            throw new CredentialsExpiredException(this.messages.getMessage("SwitchUserProcessingFilter.credentialsExpired", "User credentials have expired"));
        }
        targetUserRequest = this.createSwitchUserToken(request, username, targetUser);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Switch User Token [" + targetUserRequest + "]"));
        }
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent((ApplicationEvent)new AuthenticationSwitchUserEvent(SecurityContextHolder.getContext().getAuthentication(), targetUser));
        }
        return targetUserRequest;
    }

    private UsernamePasswordAuthenticationToken createSwitchUserToken(HttpServletRequest request, String username, UserDetails targetUser) {
        Authentication currentAuth = SecurityContextHolder.getContext().getAuthentication();
        SwitchUserGrantedAuthority switchAuthority = new SwitchUserGrantedAuthority(ROLE_PREVIOUS_ADMINISTRATOR, currentAuth);
        List<GrantedAuthority> orig = Arrays.asList(targetUser.getAuthorities());
        ArrayList<GrantedAuthority> newAuths = new ArrayList<GrantedAuthority>(orig);
        newAuths.add(switchAuthority);
        GrantedAuthority[] authorities = new GrantedAuthority[]{};
        authorities = newAuths.toArray(authorities);
        UsernamePasswordAuthenticationToken targetUserRequest = new UsernamePasswordAuthenticationToken(targetUser, targetUser.getPassword(), authorities);
        targetUserRequest.setDetails(new WebAuthenticationDetails(request));
        return targetUserRequest;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Assert.isInstanceOf((Class)(class$javax$servlet$http$HttpServletRequest == null ? (class$javax$servlet$http$HttpServletRequest = SwitchUserProcessingFilter.class$("javax.servlet.http.HttpServletRequest")) : class$javax$servlet$http$HttpServletRequest), (Object)request);
        Assert.isInstanceOf((Class)(class$javax$servlet$http$HttpServletResponse == null ? (class$javax$servlet$http$HttpServletResponse = SwitchUserProcessingFilter.class$("javax.servlet.http.HttpServletResponse")) : class$javax$servlet$http$HttpServletResponse), (Object)response);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.requiresSwitchUser(httpRequest)) {
            Authentication targetUser = this.attemptSwitchUser(httpRequest);
            SecurityContextHolder.getContext().setAuthentication(targetUser);
            httpResponse.sendRedirect(httpResponse.encodeRedirectURL(httpRequest.getContextPath() + this.targetUrl));
            return;
        }
        if (this.requiresExitUser(httpRequest)) {
            Authentication originalUser = this.attemptExitUser(httpRequest);
            SecurityContextHolder.getContext().setAuthentication(originalUser);
            httpResponse.sendRedirect(httpResponse.encodeRedirectURL(httpRequest.getContextPath() + this.targetUrl));
            return;
        }
        chain.doFilter(request, response);
    }

    private Authentication getSourceAuthentication(Authentication current) {
        Authentication original = null;
        GrantedAuthority[] authorities = current.getAuthorities();
        for (int i = 0; i < authorities.length; ++i) {
            if (!(authorities[i] instanceof SwitchUserGrantedAuthority)) continue;
            original = ((SwitchUserGrantedAuthority)authorities[i]).getSource();
            logger.debug((Object)("Found original switch user granted authority [" + original + "]"));
        }
        return original;
    }

    public void init(FilterConfig ignored) throws ServletException {
    }

    protected boolean requiresExitUser(HttpServletRequest request) {
        String uri = SwitchUserProcessingFilter.stripUri(request);
        return uri.endsWith(request.getContextPath() + this.exitUserUrl);
    }

    protected boolean requiresSwitchUser(HttpServletRequest request) {
        String uri = SwitchUserProcessingFilter.stripUri(request);
        return uri.endsWith(request.getContextPath() + this.switchUserUrl);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) throws BeansException {
        this.eventPublisher = eventPublisher;
    }

    public void setUserDetailsService(UserDetailsService authenticationDao) {
        this.userDetailsService = authenticationDao;
    }

    public void setExitUserUrl(String exitUserUrl) {
        this.exitUserUrl = exitUserUrl;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setSwitchUserUrl(String switchUserUrl) {
        this.switchUserUrl = switchUserUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    private static String stripUri(HttpServletRequest request) {
        String uri = request.getRequestURI();
        int idx = uri.indexOf(59);
        if (idx > 0) {
            uri = uri.substring(0, idx);
        }
        return uri;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

