/*
 * Decompiled with CFR 0.152.
 */
package com.jamonapi;

import com.jamonapi.AccumulateMonitor;
import com.jamonapi.AccumulateMonitorInterface;
import java.util.ArrayList;

public class ActiveStatsMonitor
extends AccumulateMonitor {
    private int max = Integer.MIN_VALUE;
    private int active;
    private int hits;
    private int total;

    public ActiveStatsMonitor() {
    }

    public ActiveStatsMonitor(AccumulateMonitorInterface accumulateMonitorInterface) {
        super(accumulateMonitorInterface);
    }

    protected synchronized void startThis() {
        ++this.active;
        ++this.hits;
        this.total += this.active;
        if (this.active > this.max) {
            this.max = this.active;
        }
    }

    protected synchronized void stopThis() {
        if (this.active > 0) {
            --this.active;
        }
    }

    protected void increaseThis(long l) {
    }

    protected synchronized void resetThis() {
        this.max = Integer.MIN_VALUE;
        this.total = 0;
        this.active = 0;
        this.hits = 0;
    }

    protected synchronized String toStringThis() {
        return String.valueOf(this.getDisplayString("Active", AccumulateMonitor.convertToString(this.active), "")) + this.getDisplayString("Avg Active", AccumulateMonitor.convertToString(this.avg()), "") + this.getDisplayString("Max Active", AccumulateMonitor.convertToString(this.max), "");
    }

    protected synchronized void getDataThis(ArrayList arrayList) {
        arrayList.add(AccumulateMonitor.convertToString(this.active));
        arrayList.add(AccumulateMonitor.convertToString(this.avg()));
        arrayList.add(AccumulateMonitor.convertToString(this.max));
    }

    protected void getHeaderThis(ArrayList arrayList) {
        arrayList.add("Active");
        arrayList.add("Avg Active");
        arrayList.add("Max Active");
    }

    final float avg() {
        if (this.hits == 0) {
            return 0.0f;
        }
        return (float)this.total / (float)this.hits;
    }

    public synchronized long getAccrued() {
        return this.active;
    }

    public static void main(String[] stringArray) throws Exception {
        ActiveStatsMonitor activeStatsMonitor = new ActiveStatsMonitor();
        System.out.println("should not have 0 divide error=" + activeStatsMonitor);
        activeStatsMonitor.start();
        activeStatsMonitor.start();
        activeStatsMonitor.start();
        activeStatsMonitor.stop();
        activeStatsMonitor.stop();
        activeStatsMonitor.start();
        System.out.println("should be active 2, avg 2, max active 3=" + activeStatsMonitor);
    }
}

