/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.core.AttributeAccessor;
import org.springframework.util.Assert;

public abstract class AttributeAccessorSupport
implements AttributeAccessor,
Serializable {
    private final Map attributes = new HashMap();

    public void setAttribute(String name, Object value) {
        Assert.notNull(name, "'name' cannot be null.");
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.removeAttribute(name);
        }
    }

    public Object getAttribute(String name) {
        Assert.notNull(name, "'name' cannot be null.");
        return this.attributes.get(name);
    }

    public Object removeAttribute(String name) {
        Assert.notNull(name, "'name' cannot be null.");
        return this.attributes.remove(name);
    }

    public boolean hasAttribute(String name) {
        Assert.notNull(name, "'name' cannot be null.");
        return this.attributes.containsKey(name);
    }

    public String[] attributeNames() {
        Set attributeNames = this.attributes.keySet();
        return attributeNames.toArray(new String[attributeNames.size()]);
    }
}

