/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.patterns.TypePattern;

public class MethodDelegateTypeMunger
extends ResolvedTypeMunger {
    private final UnresolvedType aspect;
    private final String implClassName;
    private final TypePattern typePattern;

    public MethodDelegateTypeMunger(ResolvedMember signature, UnresolvedType aspect, String implClassName, TypePattern typePattern) {
        super(ResolvedTypeMunger.MethodDelegate, signature);
        this.aspect = aspect;
        this.typePattern = typePattern;
        this.implClassName = implClassName;
    }

    public ResolvedMember getDelegate(ResolvedType targetType) {
        return AjcMemberMaker.itdAtDeclareParentsField(targetType, this.signature.getDeclaringType(), this.aspect);
    }

    public String getImplClassName() {
        return this.implClassName;
    }

    public void write(DataOutputStream s) throws IOException {
        this.kind.write(s);
        this.signature.write(s);
        this.aspect.write(s);
        s.writeUTF(this.implClassName);
        this.typePattern.write(s);
    }

    public static ResolvedTypeMunger readMethod(VersionedDataInputStream s, ISourceContext context) throws IOException {
        ResolvedMemberImpl signature = ResolvedMemberImpl.readResolvedMember(s, context);
        UnresolvedType aspect = UnresolvedType.read(s);
        String implClassName = s.readUTF();
        TypePattern tp = TypePattern.read(s, context);
        return new MethodDelegateTypeMunger(signature, aspect, implClassName, tp);
    }

    public boolean matches(ResolvedType matchType, ResolvedType aspectType) {
        if (matchType.isEnum() || matchType.isInterface() || matchType.isAnnotation()) {
            return false;
        }
        return this.typePattern.matchesStatically(matchType);
    }

    public boolean changesPublicSignature() {
        return true;
    }

    public static class FieldHostTypeMunger
    extends ResolvedTypeMunger {
        private UnresolvedType aspect;
        private final TypePattern typePattern;

        public FieldHostTypeMunger(ResolvedMember field, UnresolvedType aspect, TypePattern typePattern) {
            super(ResolvedTypeMunger.FieldHost, field);
            this.aspect = aspect;
            this.typePattern = typePattern;
        }

        public void write(DataOutputStream s) throws IOException {
            this.kind.write(s);
            this.signature.write(s);
            this.aspect.write(s);
            this.typePattern.write(s);
        }

        public static ResolvedTypeMunger readFieldHost(VersionedDataInputStream s, ISourceContext context) throws IOException {
            ResolvedMemberImpl signature = ResolvedMemberImpl.readResolvedMember(s, context);
            UnresolvedType aspect = UnresolvedType.read(s);
            TypePattern tp = TypePattern.read(s, context);
            return new FieldHostTypeMunger(signature, aspect, tp);
        }

        public boolean matches(ResolvedType matchType, ResolvedType aspectType) {
            if (matchType.isEnum() || matchType.isInterface() || matchType.isAnnotation()) {
                return false;
            }
            return this.typePattern.matchesStatically(matchType);
        }

        public boolean changesPublicSignature() {
            return false;
        }
    }
}

