/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.converters;

import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nu.xom.XMLException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class DOMConverter {
    private static final String XMLNS_NAMESPACE = "http://www.w3.org/2000/xmlns/";

    private DOMConverter() {
    }

    public static Document convert(org.w3c.dom.Document document) {
        org.w3c.dom.Element element = document.getDocumentElement();
        Element element2 = DOMConverter.convert(element);
        Document document2 = new Document(element2);
        org.w3c.dom.Node node = document.getFirstChild();
        int n = 0;
        while (node.getNodeType() != 1) {
            document2.insertChild(DOMConverter.convert(node), n);
            ++n;
            node = node.getNextSibling();
        }
        for (node = node.getNextSibling(); node != null; node = node.getNextSibling()) {
            document2.appendChild(DOMConverter.convert(node));
        }
        return document2;
    }

    public static Nodes convert(DocumentFragment documentFragment) {
        Nodes nodes = new Nodes();
        NodeList nodeList = documentFragment.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            nodes.append(DOMConverter.convert(nodeList.item(i)));
        }
        return nodes;
    }

    private static Node convert(org.w3c.dom.Node node) {
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                return DOMConverter.convert((org.w3c.dom.Element)node);
            }
            case 8: {
                return DOMConverter.convert((org.w3c.dom.Comment)node);
            }
            case 10: {
                return DOMConverter.convert((DocumentType)node);
            }
            case 3: {
                return DOMConverter.convert((org.w3c.dom.Text)node);
            }
            case 4: {
                return DOMConverter.convert((org.w3c.dom.Text)node);
            }
            case 7: {
                return DOMConverter.convert((org.w3c.dom.ProcessingInstruction)node);
            }
        }
        throw new XMLException("Unexpected DOM node type: " + s);
    }

    public static Comment convert(org.w3c.dom.Comment comment) {
        return new Comment(comment.getNodeValue());
    }

    public static Text convert(org.w3c.dom.Text text) {
        return new Text(text.getNodeValue());
    }

    public static Attribute convert(Attr attr) {
        String string = attr.getName();
        String string2 = attr.getNamespaceURI();
        if (string2 == null) {
            string2 = "";
        }
        return new Attribute(string, string2, attr.getNodeValue());
    }

    public static ProcessingInstruction convert(org.w3c.dom.ProcessingInstruction processingInstruction) {
        return new ProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getNodeValue());
    }

    public static DocType convert(DocumentType documentType) {
        DocType docType = new DocType(documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
        docType.setInternalDTDSubset(documentType.getInternalSubset());
        return docType;
    }

    public static Element convert(org.w3c.dom.Element element) {
        Element element2;
        org.w3c.dom.Node node = element;
        Node node2 = element2 = DOMConverter.makeElement(element);
        boolean bl = false;
        while (true) {
            Node node3;
            if (node.hasChildNodes() && !bl) {
                node = node.getFirstChild();
                bl = false;
            } else {
                if (node == element) break;
                if (node.getNextSibling() != null) {
                    node = node.getNextSibling();
                    bl = false;
                } else {
                    node = node.getParentNode();
                    bl = true;
                    node2 = node2.getParent();
                    continue;
                }
            }
            short s = node.getNodeType();
            if (s == 1) {
                node3 = DOMConverter.makeElement((org.w3c.dom.Element)node);
                node2.appendChild(node3);
                if (!node.hasChildNodes()) continue;
                node2 = node3;
                continue;
            }
            node3 = DOMConverter.convert(node);
            node2.appendChild(node3);
        }
        return element2;
    }

    private static Element makeElement(org.w3c.dom.Element element) {
        String string = element.getNamespaceURI();
        String string2 = element.getTagName();
        Element element2 = new Element(string2, string);
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            String string3 = attr.getName();
            String string4 = attr.getNamespaceURI();
            String string5 = attr.getValue();
            if (string4 == null) {
                string4 = "";
            }
            if (string4.equals(XMLNS_NAMESPACE)) {
                String string6;
                String string7;
                if (string3.equals("xmlns") || string5.equals(string7 = element2.getNamespaceURI(string6 = string3.substring(string3.indexOf(58) + 1)))) continue;
                element2.addNamespaceDeclaration(string6, string5);
                continue;
            }
            element2.addAttribute(new Attribute(string3, string4, string5));
        }
        return element2;
    }

    public static org.w3c.dom.Document convert(Document document, DOMImplementation dOMImplementation) {
        Element element = document.getRootElement();
        String string = element.getQualifiedName();
        String string2 = element.getNamespaceURI();
        DocType docType = document.getDocType();
        DocumentType documentType = null;
        if (docType != null) {
            documentType = dOMImplementation.createDocumentType(string, docType.getPublicID(), docType.getSystemID());
        }
        org.w3c.dom.Document document2 = dOMImplementation.createDocument(string2, string, documentType);
        org.w3c.dom.Element element2 = document2.getDocumentElement();
        boolean bl = true;
        for (int i = 0; i < document.getChildCount(); ++i) {
            Node node = document.getChild(i);
            if (node instanceof DocType) continue;
            if (node instanceof Element) {
                DOMConverter.convert((Element)node, document2);
                bl = false;
                continue;
            }
            org.w3c.dom.Node node2 = DOMConverter.convert(node, document2);
            if (bl) {
                document2.insertBefore(node2, element2);
                continue;
            }
            document2.appendChild(node2);
        }
        return document2;
    }

    private static org.w3c.dom.Node convert(Node node, org.w3c.dom.Document document) {
        if (node instanceof Text) {
            return DOMConverter.convert((Text)node, document);
        }
        if (node instanceof Comment) {
            return DOMConverter.convert((Comment)node, document);
        }
        if (node instanceof ProcessingInstruction) {
            return DOMConverter.convert((ProcessingInstruction)node, document);
        }
        throw new XMLException("Unexpected node type: " + node.getClass().getName());
    }

    private static org.w3c.dom.Comment convert(Comment comment, org.w3c.dom.Document document) {
        return document.createComment(comment.getValue());
    }

    private static org.w3c.dom.Text convert(Text text, org.w3c.dom.Document document) {
        return document.createTextNode(text.getValue());
    }

    private static org.w3c.dom.ProcessingInstruction convert(ProcessingInstruction processingInstruction, org.w3c.dom.Document document) {
        return document.createProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getValue());
    }

    private static org.w3c.dom.Element convert(Element element, org.w3c.dom.Document document) {
        org.w3c.dom.Element element2 = DOMConverter.makeElement(element, document);
        Object object = element2;
        Node node = element;
        int n = 0;
        int[] nArray = new int[10];
        int n2 = 0;
        nArray[0] = 0;
        boolean bl = false;
        while (true) {
            Object object2;
            if (!bl && node.getChildCount() > 0) {
                node = node.getChild(0);
                n = 0;
                nArray = DOMConverter.grow(nArray, ++n2);
                nArray[n2] = 0;
            } else {
                boolean bl2 = bl;
                bl = false;
                object2 = node.getParent();
                org.w3c.dom.Node node2 = object.getParentNode();
                if (node2.getNodeType() == 1 && node instanceof Element) {
                    object = node2;
                }
                if (((ParentNode)object2).getChildCount() - 1 == n) {
                    ParentNode parentNode;
                    node = object2;
                    --n2;
                    if (node == element || (parentNode = node.getParent()) == null) break;
                    n = nArray[n2];
                    bl = true;
                    continue;
                }
                nArray[n2] = ++n;
                node = ((ParentNode)object2).getChild(n);
            }
            if (node instanceof Element) {
                Node node3 = node;
                object2 = DOMConverter.makeElement((Element)node3, document);
                object.appendChild((org.w3c.dom.Node)object2);
                object = object2;
                continue;
            }
            org.w3c.dom.Node node4 = DOMConverter.convert(node, document);
            object.appendChild(node4);
        }
        return element2;
    }

    private static int[] grow(int[] nArray, int n) {
        if (n < nArray.length) {
            return nArray;
        }
        int[] nArray2 = new int[nArray.length * 2];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    private static org.w3c.dom.Element makeElement(Element element, org.w3c.dom.Document document) {
        Object object;
        String string;
        int n;
        String string2 = element.getNamespaceURI();
        org.w3c.dom.Element element2 = element.getParent() instanceof Document ? document.getDocumentElement() : (string2.equals("") ? document.createElement(element.getQualifiedName()) : document.createElementNS(string2, element.getQualifiedName()));
        int n2 = element.getAttributeCount();
        for (n = 0; n < n2; ++n) {
            Attribute attribute = element.getAttribute(n);
            string = attribute.getNamespaceURI();
            if (string.equals("")) {
                object = document.createAttribute(attribute.getLocalName());
                element2.setAttributeNode((Attr)object);
            } else {
                object = document.createAttributeNS(string, attribute.getQualifiedName());
                element2.setAttributeNodeNS((Attr)object);
            }
            object.setValue(attribute.getValue());
        }
        n = element.getNamespaceDeclarationCount();
        for (int i = 0; i < n; ++i) {
            Object object2;
            string = element.getNamespacePrefix(i);
            object = element.getNamespaceURI(string);
            ParentNode parentNode = element.getParent();
            if (!(parentNode instanceof Element) ? ((String)object).equals("") : ((String)object).equals(((Element)(object2 = (Element)parentNode)).getNamespaceURI(string))) continue;
            if ("".equals(string)) {
                object2 = document.createAttributeNS(XMLNS_NAMESPACE, "xmlns");
                element2.setAttributeNodeNS((Attr)object2);
                object2.setValue((String)object);
                continue;
            }
            object2 = document.createAttributeNS(XMLNS_NAMESPACE, "xmlns:" + string);
            element2.setAttributeNodeNS((Attr)object2);
            object2.setValue((String)object);
        }
        return element2;
    }
}

