/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.securechannel;

import java.io.IOException;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.intercept.web.FilterInvocation;
import org.acegisecurity.securechannel.ChannelEntryPoint;
import org.acegisecurity.securechannel.ChannelProcessor;
import org.acegisecurity.securechannel.RetryWithHttpEntryPoint;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class InsecureChannelProcessor
implements InitializingBean,
ChannelProcessor {
    private ChannelEntryPoint entryPoint = new RetryWithHttpEntryPoint();
    private String insecureKeyword = "REQUIRES_INSECURE_CHANNEL";

    public void setEntryPoint(ChannelEntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }

    public ChannelEntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public void setInsecureKeyword(String secureKeyword) {
        this.insecureKeyword = secureKeyword;
    }

    public String getInsecureKeyword() {
        return this.insecureKeyword;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.insecureKeyword, (String)"insecureKeyword required");
        Assert.notNull((Object)this.entryPoint, (String)"entryPoint required");
    }

    public void decide(FilterInvocation invocation, ConfigAttributeDefinition config) throws IOException, ServletException {
        if (invocation == null || config == null) {
            throw new IllegalArgumentException("Nulls cannot be provided");
        }
        Iterator iter = config.getConfigAttributes();
        while (iter.hasNext()) {
            ConfigAttribute attribute = (ConfigAttribute)iter.next();
            if (!this.supports(attribute) || !invocation.getHttpRequest().isSecure()) continue;
            this.entryPoint.commence(invocation.getRequest(), invocation.getResponse());
        }
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute != null && attribute.getAttribute() != null && attribute.getAttribute().equals(this.getInsecureKeyword());
    }
}

