/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.basicauth;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.intercept.web.AuthenticationEntryPoint;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.ui.WebAuthenticationDetails;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class BasicProcessingFilter
implements Filter,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$ui$basicauth$BasicProcessingFilter == null ? (class$org$acegisecurity$ui$basicauth$BasicProcessingFilter = BasicProcessingFilter.class$("org.acegisecurity.ui.basicauth.BasicProcessingFilter")) : class$org$acegisecurity$ui$basicauth$BasicProcessingFilter));
    private AuthenticationEntryPoint authenticationEntryPoint;
    private AuthenticationManager authenticationManager;
    static /* synthetic */ Class class$org$acegisecurity$ui$basicauth$BasicProcessingFilter;

    public void setAuthenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return this.authenticationEntryPoint;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"An AuthenticationManager is required");
        Assert.notNull((Object)this.authenticationEntryPoint, (String)"An AuthenticationEntryPoint is required");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Can only process HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Can only process HttpServletResponse");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String header = httpRequest.getHeader("Authorization");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authorization header: " + header));
        }
        if (header != null && header.startsWith("Basic ")) {
            Authentication existingAuth;
            String base64Token = header.substring(6);
            String token = new String(Base64.decodeBase64((byte[])base64Token.getBytes()));
            String username = "";
            String password = "";
            int delim = token.indexOf(":");
            if (delim != -1) {
                username = token.substring(0, delim);
                password = token.substring(delim + 1);
            }
            if ((existingAuth = SecurityContextHolder.getContext().getAuthentication()) == null || !existingAuth.getName().equals(username) || !existingAuth.isAuthenticated()) {
                Authentication authResult;
                UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken(username, password);
                authRequest.setDetails(new WebAuthenticationDetails(httpRequest, false));
                try {
                    authResult = this.authenticationManager.authenticate(authRequest);
                }
                catch (AuthenticationException failed) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Authentication request for user: " + username + " failed: " + failed.toString()));
                    }
                    SecurityContextHolder.getContext().setAuthentication(null);
                    this.authenticationEntryPoint.commence(request, response, failed);
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Authentication success: " + authResult.toString()));
                }
                SecurityContextHolder.getContext().setAuthentication(authResult);
            }
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

