/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.digestauth;

import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.AcegiMessageSource;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.dao.UserCache;
import org.acegisecurity.providers.dao.cache.NullUserCache;
import org.acegisecurity.ui.WebAuthenticationDetails;
import org.acegisecurity.ui.digestauth.DigestProcessingFilterEntryPoint;
import org.acegisecurity.ui.digestauth.NonceExpiredException;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.util.StringSplitUtils;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DigestProcessingFilter
implements Filter,
InitializingBean,
MessageSourceAware {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$ui$digestauth$DigestProcessingFilter == null ? (class$org$acegisecurity$ui$digestauth$DigestProcessingFilter = DigestProcessingFilter.class$("org.acegisecurity.ui.digestauth.DigestProcessingFilter")) : class$org$acegisecurity$ui$digestauth$DigestProcessingFilter));
    private UserDetailsService userDetailsService;
    private DigestProcessingFilterEntryPoint authenticationEntryPoint;
    protected MessageSourceAccessor messages = AcegiMessageSource.getAccessor();
    private UserCache userCache = new NullUserCache();
    private boolean passwordAlreadyEncoded = false;
    static /* synthetic */ Class class$org$acegisecurity$ui$digestauth$DigestProcessingFilter;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.userDetailsService, (String)"An AuthenticationDao is required");
        Assert.notNull((Object)this.authenticationEntryPoint, (String)"A DigestProcessingFilterEntryPoint is required");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Can only process HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Can only process HttpServletResponse");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String header = httpRequest.getHeader("Authorization");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authorization header received from user agent: " + header));
        }
        if (header != null && header.startsWith("Digest ")) {
            String serverDigestMd5;
            long nonceExpiryTime;
            String section212response = header.substring(7);
            String[] headerEntries = StringUtils.commaDelimitedListToStringArray((String)section212response);
            Map headerMap = StringSplitUtils.splitEachArrayElementAndCreateMap(headerEntries, "=", "\"");
            String username = (String)headerMap.get("username");
            String realm = (String)headerMap.get("realm");
            String nonce = (String)headerMap.get("nonce");
            String uri = (String)headerMap.get("uri");
            String responseDigest = (String)headerMap.get("response");
            String qop = (String)headerMap.get("qop");
            String nc = (String)headerMap.get("nc");
            String cnonce = (String)headerMap.get("cnonce");
            if (username == null || realm == null || nonce == null || uri == null || response == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("extracted username: '" + username + "'; realm: '" + username + "'; nonce: '" + username + "'; uri: '" + username + "'; response: '" + username + "'"));
                }
                this.fail(request, response, new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.missingMandatory", new Object[]{section212response}, "Missing mandatory digest value; received header {0}")));
                return;
            }
            if ("auth".equals(qop) && (nc == null || cnonce == null)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("extracted nc: '" + nc + "'; cnonce: '" + cnonce + "'"));
                }
                this.fail(request, response, new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.missingAuth", new Object[]{section212response}, "Missing mandatory digest value; received header {0}")));
                return;
            }
            if (!this.getAuthenticationEntryPoint().getRealmName().equals(realm)) {
                this.fail(request, response, new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.incorrectRealm", new Object[]{realm, this.getAuthenticationEntryPoint().getRealmName()}, "Response realm name '{0}' does not match system realm name of '{1}'")));
                return;
            }
            if (!Base64.isArrayByteBase64((byte[])nonce.getBytes())) {
                this.fail(request, response, new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.nonceEncoding", new Object[]{nonce}, "Nonce is not encoded in Base64; received nonce {0}")));
                return;
            }
            String nonceAsPlainText = new String(Base64.decodeBase64((byte[])nonce.getBytes()));
            String[] nonceTokens = StringUtils.delimitedListToStringArray((String)nonceAsPlainText, (String)":");
            if (nonceTokens.length != 2) {
                this.fail(request, response, new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.nonceNotTwoTokens", new Object[]{nonceAsPlainText}, "Nonce should have yielded two tokens but was {0}")));
                return;
            }
            try {
                nonceExpiryTime = new Long(nonceTokens[0]);
            }
            catch (NumberFormatException nfe) {
                this.fail(request, response, new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.nonceNotNumeric", new Object[]{nonceAsPlainText}, "Nonce token should have yielded a numeric first token, but was {0}")));
                return;
            }
            String expectedNonceSignature = DigestUtils.md5Hex((String)(nonceExpiryTime + ":" + this.getAuthenticationEntryPoint().getKey()));
            if (!expectedNonceSignature.equals(nonceTokens[1])) {
                this.fail(request, response, new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.nonceCompromised", new Object[]{nonceAsPlainText}, "Nonce token compromised {0}")));
                return;
            }
            boolean loadedFromDao = false;
            UserDetails user = this.userCache.getUserFromCache(username);
            if (user == null) {
                loadedFromDao = true;
                try {
                    user = this.userDetailsService.loadUserByUsername(username);
                }
                catch (UsernameNotFoundException notFound) {
                    this.fail(request, response, new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.usernameNotFound", new Object[]{username}, "Username {0} not found")));
                    return;
                }
                if (user == null) {
                    throw new AuthenticationServiceException("AuthenticationDao returned null, which is an interface contract violation");
                }
                this.userCache.putUserInCache(user);
            }
            if (!(serverDigestMd5 = DigestProcessingFilter.generateDigest(this.passwordAlreadyEncoded, username, realm, user.getPassword(), ((HttpServletRequest)request).getMethod(), uri, qop, nonce, nc, cnonce)).equals(responseDigest) && !loadedFromDao) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Digest comparison failure; trying to refresh user from DAO in case password had changed");
                }
                try {
                    user = this.userDetailsService.loadUserByUsername(username);
                }
                catch (UsernameNotFoundException notFound) {
                    this.fail(request, response, new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.usernameNotFound", new Object[]{username}, "Username {0} not found")));
                }
                this.userCache.putUserInCache(user);
                serverDigestMd5 = DigestProcessingFilter.generateDigest(this.passwordAlreadyEncoded, username, realm, user.getPassword(), ((HttpServletRequest)request).getMethod(), uri, qop, nonce, nc, cnonce);
            }
            if (!serverDigestMd5.equals(responseDigest)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Expected response: '" + serverDigestMd5 + "' but received: '" + responseDigest + "'; is AuthenticationDao returning clear text passwords?"));
                }
                this.fail(request, response, new BadCredentialsException(this.messages.getMessage("DigestProcessingFilter.incorrectResponse", "Incorrect response")));
                return;
            }
            if (nonceExpiryTime < System.currentTimeMillis()) {
                this.fail(request, response, new NonceExpiredException(this.messages.getMessage("DigestProcessingFilter.nonceExpired", "Nonce has expired/timed out")));
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Authentication success for user: '" + username + "' with response: '" + responseDigest + "'"));
            }
            UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken(user, user.getPassword());
            authRequest.setDetails(new WebAuthenticationDetails(httpRequest));
            SecurityContextHolder.getContext().setAuthentication(authRequest);
        }
        chain.doFilter(request, response);
    }

    public static String encodePasswordInA1Format(String username, String realm, String password) {
        String a1 = username + ":" + realm + ":" + password;
        String a1Md5 = new String(DigestUtils.md5Hex((String)a1));
        return a1Md5;
    }

    private void fail(ServletRequest request, ServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        SecurityContextHolder.getContext().setAuthentication(null);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)failed);
        }
        this.authenticationEntryPoint.commence(request, response, failed);
    }

    public static String generateDigest(boolean passwordAlreadyEncoded, String username, String realm, String password, String httpMethod, String uri, String qop, String nonce, String nc, String cnonce) throws IllegalArgumentException {
        String digest;
        String a1Md5 = null;
        String a2 = httpMethod + ":" + uri;
        String a2Md5 = new String(DigestUtils.md5Hex((String)a2));
        a1Md5 = passwordAlreadyEncoded ? password : DigestProcessingFilter.encodePasswordInA1Format(username, realm, password);
        if (qop == null) {
            digest = a1Md5 + ":" + nonce + ":" + a2Md5;
        } else if ("auth".equals(qop)) {
            digest = a1Md5 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + a2Md5;
        } else {
            throw new IllegalArgumentException("This method does not support a qop: '" + qop + "'");
        }
        String digestMd5 = new String(DigestUtils.md5Hex((String)digest));
        return digestMd5;
    }

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public DigestProcessingFilterEntryPoint getAuthenticationEntryPoint() {
        return this.authenticationEntryPoint;
    }

    public UserCache getUserCache() {
        return this.userCache;
    }

    public void init(FilterConfig ignored) throws ServletException {
    }

    public void setUserDetailsService(UserDetailsService authenticationDao) {
        this.userDetailsService = authenticationDao;
    }

    public void setAuthenticationEntryPoint(DigestProcessingFilterEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setPasswordAlreadyEncoded(boolean passwordAlreadyEncoded) {
        this.passwordAlreadyEncoded = passwordAlreadyEncoded;
    }

    public void setUserCache(UserCache userCache) {
        this.userCache = userCache;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

