/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import uk.ltd.getahead.dwr.util.JavascriptUtil;
import uk.ltd.getahead.dwr.util.Logger;

public class FileProcessor {
    private static final long servletContainerStartTime;
    private static final String etag;
    private boolean ignoreLastModified = false;
    private int compressionLevel = 7;
    private boolean scriptCompressed = true;
    private final Map scriptCache = new HashMap();
    private JavascriptUtil jsutil = new JavascriptUtil();
    private static final Logger log;
    static /* synthetic */ Class class$uk$ltd$getahead$dwr$impl$FileProcessor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFile(HttpServletRequest req, HttpServletResponse resp, String path, String mimeType) throws IOException {
        if (this.isUpToDate(req, path)) {
            resp.setStatus(304);
            return;
        }
        String output = null;
        Map map = this.scriptCache;
        synchronized (map) {
            output = (String)this.scriptCache.get(path);
            if (output == null) {
                String line;
                StringBuffer buffer = new StringBuffer();
                String resource = "/uk/ltd/getahead/dwr" + path;
                InputStream raw = this.getClass().getResourceAsStream(resource);
                if (raw == null) {
                    throw new IOException("Failed to find resource: " + resource);
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(raw));
                while ((line = in.readLine()) != null) {
                    buffer.append(line);
                    buffer.append('\n');
                }
                output = buffer.toString();
                if (mimeType.equals("text/javascript") && this.scriptCompressed) {
                    output = this.jsutil.compress(output, this.compressionLevel);
                }
                this.scriptCache.put(path, output);
            }
        }
        resp.setContentType(mimeType);
        resp.setDateHeader("Last-Modified", servletContainerStartTime);
        resp.setHeader("ETag", etag);
        PrintWriter out = resp.getWriter();
        out.println(output);
        out.flush();
    }

    private boolean isUpToDate(HttpServletRequest req, String path) {
        String givenEtag;
        if (this.ignoreLastModified) {
            return false;
        }
        long modifiedSince = req.getDateHeader("If-Modified-Since");
        if (modifiedSince != -1L) {
            modifiedSince -= modifiedSince % 1000L;
        }
        if ((givenEtag = req.getHeader("If-None-Match")) == null) {
            if (modifiedSince > servletContainerStartTime) {
                if (log.isDebugEnabled()) {
                    log.debug("Sending 304 for " + path + " If-Modified-Since=" + modifiedSince + ", Last-Modified=" + servletContainerStartTime);
                }
                return true;
            }
            return false;
        }
        if (modifiedSince == -1L) {
            if (!etag.equals(givenEtag)) {
                if (log.isDebugEnabled()) {
                    log.debug("Sending 304 for " + path + " Old ETag=" + givenEtag + ", New ETag=" + etag);
                }
                return true;
            }
            return false;
        }
        if (etag.equals(givenEtag) && modifiedSince <= servletContainerStartTime) {
            if (log.isDebugEnabled()) {
                log.debug("Sending 304 for " + path);
            }
            return true;
        }
        return false;
    }

    public boolean isIgnoreLastModified() {
        return this.ignoreLastModified;
    }

    public void setIgnoreLastModified(boolean ignoreLastModified) {
        this.ignoreLastModified = ignoreLastModified;
    }

    public void setScriptCompressed(boolean scriptCompressed) {
        this.scriptCompressed = scriptCompressed;
    }

    public void setCompressionLevel(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        long now = System.currentTimeMillis();
        servletContainerStartTime = now - now % 1000L;
        etag = "\"" + servletContainerStartTime + '\"';
        log = Logger.getLogger(class$uk$ltd$getahead$dwr$impl$FileProcessor == null ? (class$uk$ltd$getahead$dwr$impl$FileProcessor = FileProcessor.class$("uk.ltd.getahead.dwr.impl.FileProcessor")) : class$uk$ltd$getahead$dwr$impl$FileProcessor);
    }
}

