/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import java.util.List;
import org.dbunit.dataset.AbstractTable;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchColumnException;
import org.dbunit.dataset.RowOutOfBoundsException;

public class DefaultTable
extends AbstractTable {
    private final ITableMetaData _metaData;
    private final List _rowList;

    public DefaultTable(ITableMetaData metaData, List list) {
        this._metaData = metaData;
        this._rowList = list;
    }

    public DefaultTable(String tableName) {
        this._metaData = new DefaultTableMetaData(tableName, new Column[0]);
        this._rowList = new ArrayList();
    }

    public DefaultTable(String tableName, Column[] columns, List list) {
        this._metaData = new DefaultTableMetaData(tableName, columns);
        this._rowList = list;
    }

    public DefaultTable(String tableName, Column[] columns) {
        this._metaData = new DefaultTableMetaData(tableName, columns);
        this._rowList = new ArrayList();
    }

    public DefaultTable(ITableMetaData metaData) {
        this._metaData = metaData;
        this._rowList = new ArrayList();
    }

    public void addRow() throws DataSetException {
        int columnCount = this._metaData.getColumns().length;
        this._rowList.add(new Object[columnCount]);
    }

    public void addRow(Object[] values) throws DataSetException {
        this._rowList.add(values);
    }

    public void addTableRows(ITable table) throws DataSetException {
        try {
            Column[] columns = this._metaData.getColumns();
            if (columns.length > 0) {
                int i = 0;
                while (true) {
                    Object[] rowValues = new Object[columns.length];
                    for (int j = 0; j < columns.length; ++j) {
                        Column column = columns[j];
                        rowValues[j] = table.getValue(i, column.getColumnName());
                    }
                    this._rowList.add(rowValues);
                    ++i;
                }
            }
        }
        catch (RowOutOfBoundsException rowOutOfBoundsException) {
            // empty catch block
        }
    }

    public Object setValue(int row, String column, Object value) throws RowOutOfBoundsException, NoSuchColumnException, DataSetException {
        this.assertValidRowIndex(row);
        Object[] rowValues = (Object[])this._rowList.get(row);
        int columnIndex = this.getColumnIndex(column);
        Object oldValue = rowValues[columnIndex];
        rowValues[columnIndex] = value;
        return oldValue;
    }

    public ITableMetaData getTableMetaData() {
        return this._metaData;
    }

    public int getRowCount() {
        return this._rowList.size();
    }

    public Object getValue(int row, String column) throws DataSetException {
        this.assertValidRowIndex(row);
        Object[] rowValues = (Object[])this._rowList.get(row);
        return rowValues[this.getColumnIndex(column)];
    }
}

