/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.util.concurrent;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.dbunit.util.concurrent.BoundedChannel;
import org.dbunit.util.concurrent.Semaphore;

public abstract class SemaphoreControlledChannel
implements BoundedChannel {
    protected final Semaphore putGuard_;
    protected final Semaphore takeGuard_;
    protected int capacity_;

    public SemaphoreControlledChannel(int capacity) throws IllegalArgumentException {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity_ = capacity;
        this.putGuard_ = new Semaphore(capacity);
        this.takeGuard_ = new Semaphore(0L);
    }

    public SemaphoreControlledChannel(int capacity, Class semaphoreClass) throws IllegalArgumentException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.capacity_ = capacity;
        Class[] longarg = new Class[]{Long.TYPE};
        Constructor ctor = semaphoreClass.getDeclaredConstructor(longarg);
        Object[] cap = new Long[]{new Long(capacity)};
        this.putGuard_ = (Semaphore)ctor.newInstance(cap);
        Object[] zero = new Long[]{new Long(0L)};
        this.takeGuard_ = (Semaphore)ctor.newInstance(zero);
    }

    public int capacity() {
        return this.capacity_;
    }

    public int size() {
        return (int)this.takeGuard_.permits();
    }

    protected abstract void insert(Object var1);

    protected abstract Object extract();

    public void put(Object x) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.putGuard_.acquire();
        try {
            this.insert(x);
            this.takeGuard_.release();
        }
        catch (ClassCastException ex) {
            this.putGuard_.release();
            throw ex;
        }
    }

    public boolean offer(Object x, long msecs) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.putGuard_.attempt(msecs)) {
            return false;
        }
        try {
            this.insert(x);
            this.takeGuard_.release();
            return true;
        }
        catch (ClassCastException ex) {
            this.putGuard_.release();
            throw ex;
        }
    }

    public Object take() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.takeGuard_.acquire();
        try {
            Object x = this.extract();
            this.putGuard_.release();
            return x;
        }
        catch (ClassCastException ex) {
            this.takeGuard_.release();
            throw ex;
        }
    }

    public Object poll(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!this.takeGuard_.attempt(msecs)) {
            return null;
        }
        try {
            Object x = this.extract();
            this.putGuard_.release();
            return x;
        }
        catch (ClassCastException ex) {
            this.takeGuard_.release();
            throw ex;
        }
    }

    public abstract /* synthetic */ Object peek();
}

