package tudu.service.events.impl;

import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

import tudu.service.events.Event;

public class EventImpl extends Observable implements Event {
	   private String type;
	
	   public void fireEvent() {
	      super.setChanged();
	      super.notifyObservers();
	   }
	
	   public void addListener(Observer obs) {
	      super.addObserver(obs);
	   }
	   
	   public void setListeners(Set listeners) {
		   Iterator i = listeners.iterator();
		   while(i.hasNext()){
			   addObserver((Observer)i.next());
		   }
	   }

	   public String getType() {
	      return type;
	   }

	   public void setType(String type) {
	      this.type = type;
	   }
}
