/** Classe Position
* ============
*@ author Dabancourt
*@ version du 26/04/03
*/

// un arbre de decision !!!

final public class  MiniMax{

	CelluleChoix tete;
	Damier d;
	Joueur joueurFin;
	Joueur joueurTete;
	int profondeurMax;

	public MiniMax (Damier d,int profondeurMax, Joueur joueurTete){
		this.d = d;
		this.joueurTete = joueurTete;
		if (profondeurMax%2==0)
			this.joueurFin = joueurTete;
		else
			this.joueurFin = joueurTete.getAdversaire();
		this.profondeurMax=profondeurMax;
		tete = remplir(0, joueurTete);
	}
	
	public int meilleurChoix(){
		if (Puissance4.debug) tete.afficher(tete,0);
		return tete.getIndiceMiniMax();
	}
	
	public CelluleChoix remplir(int profondeur, Joueur joueur){

		if (profondeur==profondeurMax+1){
			// pas de deplacement : uniquement l'examen
			int examen=d.getExamen(joueurFin);
			CelluleChoix cFinale = new CelluleChoix(examen,-1);
			//if (Puissance4.debug) System.out.println(d+" cFinale=> examen = "+examen+"\n");
			return (cFinale);
		}
	
		CelluleChoix c = new CelluleChoix(0,-1);	// creation d'une cellule vide
		
		for (int coup=0; coup<Damier.dimensionH; coup++){
			if (profondeur==0) System.out.print(".");
			if (d.deplacement(coup, joueur)){
				if (d.estGagnant()){	// stop si qqu un a gagne
					// la valeur du coup pour le joueurFin (il n'y a que lui qui joue)
					if (joueur==joueurFin)
						c = new CelluleChoix(100000,coup);
					else
						c = new CelluleChoix(-100000,coup);
					d.annuler();
					return(c);
				}
				c.setPossibilite(coup, remplir(profondeur+1, joueur.getAdversaire()));
				d.annuler();
			}
		}
		if (joueur==joueurFin)
			c.setMiniMax(true);	// cherche a maximiser le dernier coup
		else
			c.setMiniMax(false);	// cherche a maximiser le dernier coup

		return c;
	}
}
