/** la classe Graphe
*    ============= 
* @author Dabancourt 
* @version 0.9  du 20/06/2004 
*/ 

package iut.algo;

import java.io.*;



public class GrapheValue
{
	private int [][] tab;
 	private int nbSommet;

	public GrapheValue(int nbSommet)
	{	int ligne, col;
	
		this.nbSommet = nbSommet ;
		this.tab = new int[nbSommet][nbSommet] ;
		
		for (ligne = 0; ligne < nbSommet; ligne ++){
			for (col = 0; col < nbSommet; col ++){
				tab[ligne][col]=0;
			}	
		}
	}

	public void ajouterArc (int noeudDebut, int noeudFin)
	{
		tab[noeudDebut-1][noeudFin-1]=1;
	}


	public String toString() 
	{	int ligne, col;
		String res;
		
		res="";
		for (ligne = 0; ligne < nbSommet; ligne ++){
			for (col = 0; col < nbSommet; col ++){
				res = res + "\t" + tab[ligne][col];
			}	
			res = res + "\n";
		}
		return res;
	}

	public void floyd() 
	{	int [][] floyd;
		int ligne, col;
		int infini = Integer.MAX_VALUE;
		
		
		int k,i,j;
		int coutik, coutkj, u;
		
		floyd = new int[nbSommet][nbSommet];
		for (ligne = 0; ligne < nbSommet; ligne ++){
			for (col = 0; col < nbSommet; col ++){
				if (tab[ligne][col]==0)
					floyd[ligne][col]=infini;
				else
					floyd[ligne][col]=tab[ligne][col];
			}	
		}

		for (k=0; k<nbSommet; k++)
			for (i=0; i<nbSommet; i++)
				for (j=0; j<nbSommet; j++)
				{
					coutik=floyd[i][k];
					coutkj=floyd[k][j];
					
					if (coutik!=infini && coutkj!=infini)
					{	u = coutik + coutkj;
						if (u<floyd[i][j])
							floyd[i][j]=u;
					}
				}
				
		for (i=0; i<nbSommet; i++)
		{
			for (j=0; j<nbSommet; j++)
			{
				System.out.print("\t"+floyd[i][j]);
			}
			System.out.print("\n");
		}
	}
}