/** Classe Grille
* ============
*@ author Dabancourt
*@ version du 26/04/03
*/

import java.util.Stack;



class  Grille{
  
	// declaration des attributs:
	static int dimensionH=8;	// largeur du Grille=8
	static int dimensionV=6;	// hauteur du Grille=6
	static int taille=4;		// nombre de pion a aligner=4
	int place[]; 
	Pion tab[][];
	
	int examen;		// entier qui juge le Grille
	int gagnant;
	int nbCaseLibre;
	Stack <Integer> memoire;
		
	// declaration des constructeurs:
	public Grille(){
		gagnant = 0;	// personne ne gagne au debut !!!
		nbCaseLibre=dimensionH*dimensionV;
		place = new int [dimensionH];  	// si place[2]=1, la prochaine fois qu'on joue en 2, 
						// le pion ira sur la ligne 1
		for (int i=0; i<dimensionH; i++) place[i]=0;
		
		tab=new Pion[dimensionH][dimensionV];
		init();
		memoire=new Stack <Integer>();
		examen=0;
	}
	// declaration des methodes:
	private void init(){
		for (int lig=0; lig<dimensionV; lig++)
			for (int col=0; col<dimensionH; col++)
				tab[col][lig]=null;
	}
	
	public boolean estFini(){ return ((gagnant != 0)||(nbCaseLibre==0));}
	
	public boolean coupValide(int coup){ 
		if ((coup<0) || (coup>=dimensionH))
			return false;
		return (place[coup]<dimensionV);
	}
	
	public String toString(){
		String s="";
		for (int col=0; col<dimensionH; col++)
			s+="-"+col;
		s+="-\n";
		for (int col=0; col<dimensionH; col++)
			s+="--";
		s+="-\n";
		for (int lig=dimensionV-1; lig>=0; lig--){
		//for (int lig=4-1; lig>=0; lig--){
			for (int col=0; col<dimensionH; col++)
				if (tab[col][lig]!=null)
					s+="|"+tab[col][lig].toString();
				else
					s+="| ";
			s+="|\n";
			for (int col=0; col<dimensionH; col++)
				s+="--";
			s+="-\n";
		}
		return s;
	}

	public boolean deplacement(int coup, Joueur joueur){	// on peut jouer
		if (place[coup]==dimensionV)
			return false;
		// on peut jouer !
		
		tab[coup][place[coup]]=new Pion(new Position(coup,place[coup]),joueur.getCouleur());
		place[coup]=place[coup]+1;

		memoire.push(new Integer(coup));
		nbCaseLibre--;
		
		return true;
	}
	
}
