/** Point & PointCouleur & Figure !!
*    ============= 
* @author Dabancourt 
* @version 0.9  du 20/06/2004 			g++ E6_3.cpp -o E6_3
*/ 

#include <sstream>
#include <iostream>
using namespace std;

class PointCouleur;
class Figure;


class Point {  
protected:	int x, y ;
public:	Point();
	Point(int a, int b);
	string toString();
};

class PointCouleur: public Point{	// l'héritage est public !!! pour utiliser le polymorpisme dans Figure.
	int couleur;
public:	PointCouleur();
	PointCouleur(int a, int b, int c);
	string toString();
};


Point::Point(){x=0; y=0;}
Point::Point(int a, int b){x = a;y = b;}
string Point::toString(){
	ostringstream stx, sty;
	stx << x;
	sty << y;
	return "[x="+stx.str()+";y="+sty.str()+"] "; 
}

PointCouleur::PointCouleur():Point(0, 0){ couleur = 0;}
PointCouleur::PointCouleur(int a, int b, int c):Point(a, b){ couleur = c;}
string PointCouleur::toString(){ 
	ostringstream stx, sty, stc;
	stx << x;
	sty << y;
	stc << couleur;
	return "[x="+stx.str()+";y="+sty.str()+" + couleur="+stc.str()+"] ";
}

class Figure {  

	Point * tab;
	int nbPoint;	//nb de points dans la figure (10 max)

public:	Figure();
	void ajouterPoint(Point p);
	string toString();
};

Figure::Figure(){nbPoint = 0;	tab = new Point[10];}
void Figure::ajouterPoint(Point p){
	if (nbPoint!=10) {
		tab[nbPoint] = p;
		nbPoint = nbPoint + 1;
	}
}
string Figure::toString(){
	string res="";
	for (int i=0; i<nbPoint; i++)
		res = res + tab[i].toString();
	res = res +"\n";
	return res;
}


/***************************************************/

int main()
{ 

	Point p1, p2;
	PointCouleur pc1, pc2;
	Figure f;

	p1 = Point (44,20);
	p2 = Point (88,0);

	pc1 = PointCouleur(55,55,1);
	pc2 = PointCouleur(13,79,5);

	f = Figure();

	f.ajouterPoint(p1);
	f.ajouterPoint(p2);
	f.ajouterPoint(pc1);	// le polymorphisme
	f.ajouterPoint(pc2);

	cout << "f : " << f.toString();
}

