/**
 * Classe ListeReel
 * Une ListeReel est constue de CelluleReel.
 *
 *
 * @author Dabancourt C.
 * @version 1.0
 */

#include "ListeReel.h"

    ListeReel::ListeReel ( ) 
	{
		tete = null ;
	}

	boolean ListeReel::estVide ( ) 
	{
		return(tete == null);
	}

	void ListeReel::ajouterTete (float e )
	{
		CelluleReel nouvCel;
	
		nouvCel = new CelluleReel(e, tete) ;   // la nouvelle cellule pointe comme tte, et contient llment e.
		tete = nouvCel ;
	}

	void ListeReel::ajouterQueue (float e) 
	{
		CelluleReel ptr, nouvCel;

		ptr = tete ;
		while ( ptr.getSuivant ( ) != null ) 
		{
			ptr = ptr.getSuivant ( ) ;
		}
		nouvCel = new CelluleReel (e, null ) ;
		ptr.setSuivant( nouvCel) ;
	}


	void ListeReel::retirerTete ( ) 
	{
		tete = tete.getSuivant ( ) ;
	}


	void ListeReel::retirerQueue ( ) 
	{
		CelluleReel ptr;
		
		if (tete == null)
			return ;
			
		if (tete.getSuivant() == null)
		{
			tete = null ;
			return ;
		}

		ptr = tete ;
		while ( ptr.getSuivant().getSuivant() != null) 
		{
			ptr = ptr.getSuivant();
		}
		ptr.setSuivant(null);
	}
	
	
	boolean ListeReel::contient(float x) 
	{
		CelluleReel iterateur;

		iterateur = tete ;
		while(iterateur !=  null) 
		{
			if (iterateur.getValeur() == x) 
				return true;		// on quitte la mthode
			iterateur = iterateur.getSuivant() ;
		}
		return false;
	}
	
	int ListeReel::profondeur( ) 
	{
		return (profondeur(tete));	
	}

	int ListeReel::profondeur(CelluleReel c) 
	{
		if (c==null)
			return 0;
			
		return (1+profondeur(c.getSuivant()));	
	}

	
	void ListeReel::afficher ( ) 
	{
		CelluleReel ptr = tete ;
		while ( ptr != null) 
		{
			cout << ptr.getValeur();
			ptr = ptr.getSuivant();
		}
		cout << "***" ;
	}

