


#include "ABE.h"
#include <iostream>
using namespace std;	// pour ecrire "cout" au lieu de "std::cout"


	ABE::ABE(){	// un arbre vide
		gauche=null; 
		droit=null;
	}


	ABE::ABE(int valeur){	// un arbre avec une valeur
		this(valeur,null,null);
	}


	ABE::ABE(int valeur, ABE gauche, ABE droit){ 
		this.valeur = valeur;
		this.gauche = gauche;
		this.droit = droit;
	}
	
	
	int ABE::getValeur(){	return valeur;}
	ABE ABE::getDroit() {	return droit;}
	ABE ABE::getGauche(){	return gauche;}
	
 
	string ABE::toString(){ 
		string s="";
		
		if (gauche !=null) { 
			s = "[" + gauche.toString()+"]"; 
		}
		
		s = s + " "+ valeur+ " "; 
		
		if (droit !=null) { 
			s = s + "["+ droit.toString()+"]"; 
		} 
		return s ; 
	} 

	/*******************************
	 * les parcours                *
	 *******************************/
	 	
	void ABE::parcoursPrefixe() {
		cout << "parcours Prefixe";
		parcoursPrefixe(this);
	}
	
	void ABE::parcoursPrefixe(ABE ab) 
	{
		System.out.println(ab.getValeur());					// traitement
		if (ab.getGauche() != null) parcoursPrefixe(ab.getGauche());	// appel rcursif
		if (ab.getDroit()  != null) parcoursPrefixe(ab.getDroit());		// appel rcursif
	}
	
	/*******************************/
	void ABE::parcoursInfixe() {
		System.out.println("parcours Infixe");
		parcoursInfixe(this);
	}
	
	void ABE::parcoursInfixe(ABE ab) 
	{
		if (ab.getGauche() != null) parcoursInfixe(ab.getGauche());	// appel rcursif
		cout << "*";
		cout << ab.getValeur();				// traitement
		if (ab.getDroit()  != null) parcoursInfixe(ab.getDroit());	// appel rcursif
	}
	
	/*******************************/
	void ABE::parcoursSuffixe() {
		cout << "parcours Suffixe";
		parcoursSuffixe(this);
	}
	
	void ABE::parcoursSuffixe(ABE ab) 
	{
		if (ab.getGauche() != null) parcoursSuffixe(ab.getGauche());// appel rcursif
		if (ab.getDroit()  != null) parcoursSuffixe(ab.getDroit());	// appel rcursif
		cout << ab.getValeur();				// traitement
	}
