#include "ABREntier.h"

    ABREntier::ABREntier(){	// un arbre vide
		racine=null;
	}


	ABREntier::ABREntier(int valeur){	// un arbre avec une valeur
		racine=new Noeud(valeur);
	}


	boolean ABREntier::ajouterValeur (int val){ 
		
		ABREntier g,d;
		int x;
		
		if (racine==null){ 					// arrt rcursif
			racine = new Noeud(val);
			return (true) ; 
		} 
		
		x = racine.getValeur();
		if (val==x) 
			return false ; 
		else if (val<x){ 
			g = racine.getGauche() ;
			return g.ajouterValeur(val); // appel rcursif
		} 
		else { 
			d = racine.getDroit(); 
			return d.ajouterValeur(val); // appel rcursif
		}
	} 
	
	
	boolean ABREntier::rechercher (int val){ 
		ABREntier g,d;
		int x;
		if (racine==null)
			return false;
		
		x = racine.getValeur();
		if (val==x) 
			return true; 
		else if (val<x){ 
				g = racine.getGauche() ;
				return (g.rechercher(val));
		}else { 
				d = racine.getDroit() ; 
				return (d.rechercher(val)); 
		}
	}
	
	int ABREntier::rechercherMax (){ 
		
		ABREntier d;
		System.out.println("valeur : "+racine.getValeur()) ;
		
		d = (ABREntier)racine.getDroit() ;
		
		if (d.racine == null)
			return racine.getValeur();
		
		return d.rechercherMax ();
		
	}
	
	
	boolean ABREntier::supprime(int val){
		
		ABREntier g,d;
		int x;
		
		if (racine==null)
			return (false);
		
		g = (ABREntier)racine.getGauche() ;
		d = (ABREntier)racine.getDroit() ;
		x = racine.getValeur();
		
		if (val==x){
			
			if (g.racine == null){
				racine = d.racine;
			}else if(d.racine == null) {
				racine = g.racine;
			}else{
				int plusGrand=g.rechercherMax();	// trouver(+gd)
				racine.setValeur(plusGrand);		// racine.setValeur(+gd);
				g.supprime(plusGrand);				// racine.gauche.supprime(+gd);
			}
			return ( true ) ;
		}
		else if (val<x)
		{
				return (g.supprime(val));
		}
		else 
		{
				return (d.supprime(val));
		}
	}



	string ABREntier::toString(){ 
		ABREntier g,d;
		
		if (racine ==null)
			return "";
			
		g=racine.getGauche();
		d=racine.getDroit();
		
		String s="";
		
		if (g!=null) { 
			s = "[" + g.toString()+"]"; 
		}
		
		s = s + " "+ racine.getValeur()+ " "; 
		
		if (d!=null) { 
			s = s + "["+ d.toString()+"]"; 
		}
		
		return s ; 
	} 

