/**
 * Classe ListeNoeud
 * Une ListeNoeud est constuee de CelluleNoeud.
 *
 *
 * @author Dabancourt C.
 * @version 1.0
 */
#include "ListeNoeud.h"

	ListeNoeud::ListeNoeud ( ) 
	{
		tete = null ;
	}


	boolean ListeNoeud::estVide ( ) 
	{
		return(tete == null);
	}



	void ListeNoeud::ajouterTete (Noeud e )
	{
		CelluleNoeud nouvCel;
	
		nouvCel = new CelluleNoeud(e, tete) ;   // la nouvelle cellule pointe comme tete, et contient l'element e.
		tete = nouvCel ;
	}


	void ListeNoeud::ajouterQueue (Noeud e) 
	{
		CelluleNoeud ptr, nouvCel;

		ptr = tete ;
		while ( ptr.getSuivant ( ) != null ) 
		{
			ptr = ptr.getSuivant ( ) ;
		}
		nouvCel = new CelluleNoeud (e, null ) ;
		ptr.setSuivant( nouvCel) ;
	}


	void ListeNoeud::retirerTete ( ) 
	{
		tete = tete.getSuivant ( ) ;
	}


	void ListeNoeud::retirerQueue ( ) 
	{
		CelluleNoeud ptr;
		
		ptr = tete ;
		while ( ptr.getSuivant().getSuivant() != null) 
		{
			ptr = ptr.getSuivant();
		}
		ptr.setSuivant(null);
	}
	
	Noeud ListeNoeud::retirerQueue (int i) 
	{
		CelluleNoeud ptr, dernier;
		
		ptr = tete;
		
		if (tete==null)	// erreur
			return null;
			
		if (tete.getSuivant()==null){
			dernier = tete;
			tete=null;
		}
		else
		{
			while ( ptr.getSuivant().getSuivant() != null) 
			{
				ptr = ptr.getSuivant();
			}
			dernier = ptr.getSuivant();
			ptr.setSuivant(null);
		}
		return dernier.getValeur();
	}
	
	boolean ListeNoeud::contient(Noeud x) 
	{
		CelluleNoeud iterateur;

		iterateur = tete ;
		while(iterateur !=  null) 
		{
			if (iterateur.getValeur() == x) 
				return true;		// on quitte la methode
			iterateur = iterateur.getSuivant() ;
		}
		return false;
	}
	
	
	void ListeNoeud::afficher ( ) 
	{
		CelluleNoeud ptr = tete ;
		while ( ptr != null) 
		{
			System.out.println(ptr.getValeur());
			ptr = ptr.getSuivant();
		}
		cout << "***";
	}

