#include "ABRPari"

	ABRPari::ABRPari(){	// un arbre vide
		racine=null;
	}


	ABRPari::ABRPari(Pari valeur){	// un arbre avec une valeur
		racine=new NoeudPari(valeur);
	}


	boolean ABRPari::ajouterValeur (Pari val){ 
		
		ABRPari g,d;
		Pari x;
		
		if (racine==null){ 					// arrt rcursif
			racine = new NoeudPari(val);
			return (true) ; 
		} 
		
		x = racine.getValeur();
		if (val.equals(x)) 
			racine.rejouer() ; 
		else if (val.compareTo(x)<0){ 
			g = racine.getGauche() ;
			return g.ajouterValeur(val); // appel rcursif
		} 
		else { 
			d = racine.getDroit(); 
			return d.ajouterValeur(val); // appel rcursif
		}
		return (true);
	} 
	
	
	int ABRPari::rechercher (Pari val){ 
		ABRPari g,d;
		Pari x;
		if (racine==null)
			return 0;
		
		x = racine.getValeur();
		if (val.equals(x)) 
			return racine.getNbPari(); 
		else if (val.compareTo(x)<0){ 
				g = racine.getGauche() ;
				return (g.rechercher(val));
		}else { 
				d = racine.getDroit() ; 
				return (d.rechercher(val)); 
		}
	}
	



	String ABRPari::toString(){ 
		ABRPari g,d;
		
		if (racine ==null)
			return "";
			
		g=racine.getGauche();
		d=racine.getDroit();
		
		String s="";
		
		if (g!=null) { 
			s = "[" + g.toString()+"]"; 
		}
		
		s = s + " "+ racine.getValeur()+ " "; 
		
		if (d!=null) { 
			s = s + "["+ d.toString()+"]"; 
		}
		
		return s ; 
	} 



}
