/**
 * Classe ABE
 *
 *
 * @author Dabancourt C.
 * @version 1.0
 */
package iut.algo;

import java.util.*;

public class ABE{

	protected ABE gauche, droit;
	protected int valeur;


	public ABE(){	// un arbre vide
		gauche=null; 
		droit=null;
	}


	public ABE(int valeur){	// un arbre avec une valeur
		this(valeur,null,null);
	}


	public ABE(int valeur, ABE gauche, ABE droit){ 
		this.valeur = valeur;
		this.gauche = gauche;
		this.droit = droit;
	}
	
	
	public int getValeur(){	return valeur;}
	public ABE getDroit() {		return droit;}
	public ABE getGauche(){		return gauche;}
	
 
	public String toString(){ 
		String s="";
		
		if (gauche !=null) { 
			s = "[" + gauche.toString()+"]"; 
		}
		
		s = s + " "+ valeur+ " "; 
		
		if (droit !=null) { 
			s = s + "["+ droit.toString()+"]"; 
		} 
		return s ; 
	} 

	/*******************************
	 * les parcours                *
	 *******************************/
	 	
	public void parcoursPrefixe() {
		System.out.println("parcours Prefixe");
		parcoursPrefixe(this);
	}
	
	public void parcoursPrefixe(ABE ab) 
	{
		System.out.println(ab.getValeur());					// traitement
		if (ab.getGauche() != null) parcoursPrefixe(ab.getGauche());	// appel recursif
		if (ab.getDroit()  != null) parcoursPrefixe(ab.getDroit());		// appel recursif
	}
	
	/*******************************/
	public void parcoursInfixe() {
		System.out.println("parcours Infixe");
		parcoursInfixe(this);
	}
	
	public void parcoursInfixe(ABE ab) 
	{
		if (ab.getGauche() != null) parcoursInfixe(ab.getGauche());	// appel recursif
		System.out.print("*");
		System.out.println(ab.getValeur());				// traitement
		if (ab.getDroit()  != null) parcoursInfixe(ab.getDroit());	// appel recursif
	}
	
	/*******************************/
	public void parcoursSuffixe() {
		System.out.println("parcours Suffixe");
		parcoursSuffixe(this);
	}
	
	public void parcoursSuffixe(ABE ab) 
	{
		if (ab.getGauche() != null) parcoursSuffixe(ab.getGauche());// appel recursif
		if (ab.getDroit()  != null) parcoursSuffixe(ab.getDroit());	// appel recursif
		System.out.println(ab.getValeur());				// traitement
	}
	
	/*******************************/
/*	public void parcoursLargeur() // pas recursif !
	{
		ABE ab;
		ListeABE liste;
		
		System.out.println("parcours Largeur");
		
		liste = new ListeABE();
		liste.ajouterTete(this);	
		
		while (liste.estVide() == false){
			ab = liste.retirerQueue();
			System.out.println(n.getValeur());
			if (ab.getGauche() != null){
				liste.ajouterTete(ab.getGauche());
			}
			if (ab.getDroit()  != null){
				liste.ajouterTete(ab.getDroit());
			}
		}		
	}
*/
	
}
