#include "DateHistorique.h"
#include <cstdlib>
#include <sstream>

using namespace std;

DateHistorique::DateHistorique():Date() // entre le ":" et le "{", c'est le "super"
{
	description = std::string();
}
	
DateHistorique::DateHistorique(int j, int m, int a, std::string d):Date(j, m, a)
{
	description = std::string(d);
}
	
DateHistorique::DateHistorique(DateHistorique * d)
{
	DateHistorique(d->getJour(), d->getMois(), d->getAnnee(), std::string(d->getDescription()) );
}

DateHistorique::~DateHistorique(){
 
	cout << "\n destructeur (DateHistorique) : ";
	cout << this->dateEnChaine() <<" disparait de la mmoire \n";
 delete (&description);
}	

std::string DateHistorique::getDescription() const{ return description;}

void DateHistorique::setDescription(std::string  d) { 
    this->description = std::string(d);
}

// les autres mthodes

std::string DateHistorique::dateEnChaine() const{
    std::ostringstream oss;
    oss << Date::dateEnChaine() << " : "<< description ;
    std::string resultat(oss.str()); 
    return(resultat);
}
	
bool DateHistorique::estEgale(DateHistorique DateParam) const {
	return (getJour()==DateParam.getJour() && getMois()==DateParam.getMois() && getAnnee()==DateParam.getAnnee() && description==DateParam.description);
}
