// compiler :   g++ Date.cpp -c
 
#include "Date.h" 		// on utilise la classe date
#include <cstdlib>
#include <sstream>

using namespace std;

Date::Date () {
        cout << "\n constructeur () 1 " << std::endl;
		jour=1; mois=1; annee=1970;
}
	
Date::Date(int jour,int mois,int an) {
        cout << "\n constructeur (int,int,int) 2 " << std::endl;
		this->jour=jour; 
		this->mois=mois; 
		this->annee=an;
}

Date::Date( Date * paramDate )  {
        cout << "\n constructeur (Date) 3 " << std::endl;
		jour = paramDate->getJour( ) ;
		mois = paramDate->getMois( ) ;
		annee = paramDate->getAnnee( ) ;
}

Date::~Date(){
	cout << "\n destructeur (Date) : ";
	cout << this->dateEnChaine() <<" disparait de la mmoire \n";
}

// les mthodes appeles "accesseurs"
int Date::getJour( ) const { return jour;}
int Date::getMois( ) const { return mois;}
int Date::getAnnee( ) const { return annee;}

void Date::setJour(int j){jour=j;}
void Date::setMois(int m){mois=m;}
void Date::setAnnee(int a){annee=a;}
    
// les mthodes d'affichage

std::string Date::dateEnChaine( ) const {
    std::ostringstream oss;
    oss << jour << "/" << mois << "/"<< annee ;
    std::string resultat(oss.str()); 

    return  resultat;
}


bool Date::estEgale(const Date * DateParam)  const {
     if ( annee==DateParam->getAnnee() && mois==DateParam->getMois( ) && jour==DateParam->getJour() ) 
        return true ;            // mme anne, mme mois et mme jour !
     else
         return false ;
}

bool Date::estBissextile() const{
	int reste, DeuxPremierChiffre,siecle ;

	siecle = annee % 100 ;
	DeuxPremierChiffre = annee / 100 ;
	reste = annee % 4 ;

	if ( (DeuxPremierChiffre % 4) == 0 && (siecle == 0) ) 
		return true ;            // les annees 1600, 2000, 2200 ... ne sont pas bissextiles
	if (siecle == 0)  
		return  false ;            // les annees 1800, 1900 ... sont bissextiles
	if ( (reste % 4) == 0 )  
		return  true;            // les annees divisibles par 4 sont bissextiles
	return false;
}


bool Date::precede(const Date *DateParam) const{
	if (annee < DateParam->annee)  
		return true ;	
	if (annee==DateParam->annee && mois < DateParam->mois )  
		return true ;	   // meme annee, comparaison des mois
	if (annee==DateParam->annee && mois==DateParam->mois && jour < DateParam->jour)  
		return true ;   // meme annee et meme mois, comparaison des jours

	return false ;
}




