/**
 * Classe Noeud
 * Un Noeud pour ABREntier
 *
 * @author Dabancourt C.
 * @version 1.0
 */
package iut.algo;

import java.util.*;

public class Noeud { 

	protected int valeur;
	protected ABREntier gauche, droit;

	public Noeud(){
		valeur = Integer.MIN_VALUE;
		gauche = new ABREntier();
		droit  = new ABREntier();
	}

	public Noeud(int valeur){
		this();
		this.valeur=valeur;
	}

	public Noeud(int valeur, ABREntier gauche, ABREntier droit){ 
		this.valeur=valeur;
		this.gauche=gauche;
		this.droit=droit;

	}
	
	public ABREntier getDroit(){		return droit;}
	public ABREntier getGauche(){	return gauche;}
	public void setDroit(ABREntier droit){  this.droit  = droit;}
	public void setGauche(ABREntier gauche){this.gauche = gauche;}
	
	public void setValeur(int valeur){		this.valeur=valeur;}
	public int getValeur(){		return valeur;}
	public boolean estFeuille(){	return (droit==null && gauche==null);}
	
	public String toString(){
		return (" "+valeur);
	}
}
	
