package iut.algo;

import java.util.*;


public class ABRPari{

	private NoeudPari racine;

	public ABRPari(){	// un arbre vide
		racine=null;
	}


	public ABRPari(Pari valeur){	// un arbre avec une valeur
		racine=new NoeudPari(valeur);
	}


	public boolean ajouterValeur (Pari val){ 
		
		ABRPari g,d;
		Pari x;
		
		if (racine==null){ 					// arret recursif
			racine = new NoeudPari(val);
			return (true) ; 
		} 
		
		x = racine.getValeur();
		if (val.equals(x)) 
			racine.rejouer() ; 
		else if (val.compareTo(x)<0){ 
			g = racine.getGauche() ;
			return g.ajouterValeur(val); // appel recursif
		} 
		else { 
			d = racine.getDroit(); 
			return d.ajouterValeur(val); // appel recursif
		}
		return (true);
	} 
	
	
	public int rechercher (Pari val){ 
		ABRPari g,d;
		Pari x;
		if (racine==null)
			return 0;
		
		x = racine.getValeur();
		if (val.equals(x)) 
			return racine.getNbPari(); 
		else if (val.compareTo(x)<0){ 
				g = racine.getGauche() ;
				return (g.rechercher(val));
		}else { 
				d = racine.getDroit() ; 
				return (d.rechercher(val)); 
		}
	}
	
	public int rechercher2 (Pari val, int nbIteration){ // utiliser "rechercher2 (val, 0)"
		ABRPari g,d;
		Pari x;

		if (racine==null)
			return 0;
		
		x = racine.getValeur();
		if (val.equals(x)){
			System.out.println("nb iteration ="+nbIteration);
			return racine.getNbPari(); 
		}
		else if (val.compareTo(x)<0){ 
				g = racine.getGauche() ;
				return (g.rechercher2(val, nbIteration + 1));
		}else { 
				d = racine.getDroit() ; 
				return (d.rechercher2(val, nbIteration + 1)); 
		}
	}
	public String toString(){ 
		ABRPari g,d;
		
		if (racine ==null)
			return "";
			
		g=racine.getGauche();
		d=racine.getDroit();
		
		String s="";
		
		if (g!=null) { 
			s = "[" + g.toString()+"]"; 
		}
		
		s = s + " "+ racine.getValeur()+ " "; 
		
		if (d!=null) { 
			s = s + "["+ d.toString()+"]"; 
		}
		
		return s ; 
	} 



}
