/** le jeu de cartes
*    ============= 
* @author Dabancourt 
* @version 0.9  du 20/06/2004 
*/ 

import java.io.*;

class JeuDeCarte {  

	int nbCartes;
	Carte[] tab;

	/*** constructeurs ***/
	public JeuDeCarte()
	{
		this(32);
	}


	public JeuDeCarte(int nbCartes)
	{
		int compteur;

		this.nbCartes = nbCartes;
		tab = new Carte[nbCartes];

		compteur=0;
		while (compteur<nbCartes)
		{
			tab[compteur] = new Carte(compteur/4, compteur%4);
			compteur = compteur + 1;
		}
	}
	
	
	/*** melanger ***/
	public void melanger()
	{
		int carteModifie;
		Carte tempEchange;
		int positionCarteHasard;


		carteModifie = nbCartes;
		positionCarteHasard = (int)(carteModifie * Math.random());
		while (carteModifie > 0)
		{
			tempEchange = tab[carteModifie-1];
			tab[carteModifie-1] = tab[positionCarteHasard];
			tab[positionCarteHasard] = tempEchange;
			
			positionCarteHasard = (int)(carteModifie * Math.random());
			carteModifie = carteModifie - 1;
		}
	}

	/*** affichage ***/
	public void afficher()
	{
		for (int i=0; i<nbCartes; i++)
		{
			tab[i].afficher();
			System.out.print(" - ");
		}
		System.out.println();
	}
		

}