/**
 * Classe ListeReel
 * Une ListeReel est constuee de CelluleReel.
 *
 *
 * @author Dabancourt C.
 * @version 1.0
 */

public class ListeReel
{


	private CelluleReel tete;
	
	public ListeReel ( ) 
	{
		tete = null ;
	}


	public boolean estVide ( ) 
	{
		return(tete == null);
	}



	public void ajouterTete (float e )
	{
		CelluleReel nouvCel;
	
		nouvCel = new CelluleReel(e, tete) ;   // la nouvelle cellule pointe comme tete, et contient l element e.
		tete = nouvCel ;
	}


	public void ajouterQueue (float e) 
	{
		CelluleReel ptr, nouvCel;

		ptr = tete ;
		while ( ptr.getSuivant ( ) != null ) 
		{
			ptr = ptr.getSuivant ( ) ;
		}
		nouvCel = new CelluleReel (e, null ) ;
		ptr.setSuivant( nouvCel) ;
	}


	public void retirerTete ( ) 
	{
		tete = tete.getSuivant ( ) ;
	}


	public void retirerQueue ( ) 
	{
		CelluleReel ptr;
		
		if (tete == null)
			return ;
			
		if (tete.getSuivant() == null)
		{
			tete = null ;
			return ;
		}

		ptr = tete ;
		while ( ptr.getSuivant().getSuivant() != null) 
		{
			ptr = ptr.getSuivant();
		}
		ptr.setSuivant(null);
	}
	
	
	public boolean contient(float x) 
	{
		CelluleReel iterateur;

		iterateur = tete ;
		while(iterateur !=  null) 
		{
			if (iterateur.getValeur() == x) 
				return true;		// on quitte la methode
			iterateur = iterateur.getSuivant() ;
		}
		return false;
	}

	public float trouverMax() 
	{
		CelluleReel iterateur;
		float max;

		if (tete==null) return (-9999);	// valeur pour une liste vide

		iterateur = tete ;
		max = tete.getValeur();
		while(iterateur !=  null) 
		{
			if (iterateur.getValeur() > max) 
				max = iterateur.getValeur();		// on quitte la methode
			iterateur = iterateur.getSuivant() ;
		}
		return max;
	}

	public void supprimerMax(float max) 
	{
		CelluleReel iterateur;

		if (tete==null) return;	// valeur pour une liste vide

		iterateur = tete ;
		while(iterateur !=  null) 
		{
			if (iterateur==tete && iterateur.getValeur() == max) {
				tete = tete.getSuivant();
				iterateur = tete;
			}
			else if (iterateur!=tete && iterateur.getValeur() == max) {
				iterateur.setSuivant( iterateur.getSuivant().getSuivant() ) ;
			}
			else
				iterateur = iterateur.getSuivant();
		}
		return;
	}


	
	public int profondeur( ) 
	{
		return (profondeur(tete));	
	}

	private int profondeur(CelluleReel c) 
	{
		if (c==null)
			return 0;
			
		return (1+profondeur(c.getSuivant()));	
	}

	
	public void afficher ( ) 
	{
		CelluleReel ptr = tete ;
		while ( ptr != null) 
		{
			System.out.println(ptr.getValeur());
			ptr = ptr.getSuivant();
		}
		System.out.println("***");
	}
}

