/**
 * Classe ListeNoeud
 * Une ListeNoeud est constuee de CelluleNoeud.
 *
 *
 * @author Dabancourt C.
 * @version 1.0
 */
package iut.algo;

import java.util.*;
import iut.algo.Noeud;

public class ListeNoeud
{


	private CelluleNoeud tete;
	
	public ListeNoeud ( ) 
	{
		tete = null ;
	}


	public boolean estVide ( ) 
	{
		return(tete == null);
	}



	public void ajouterTete (Noeud e )
	{
		CelluleNoeud nouvCel;
	
		nouvCel = new CelluleNoeud(e, tete) ;   // la nouvelle cellule pointe comme tete, et contient l'element e.
		tete = nouvCel ;
	}


	public void ajouterQueue (Noeud e) 
	{
		CelluleNoeud ptr, nouvCel;

		ptr = tete ;
		while ( ptr.getSuivant ( ) != null ) 
		{
			ptr = ptr.getSuivant ( ) ;
		}
		nouvCel = new CelluleNoeud (e, null ) ;
		ptr.setSuivant( nouvCel) ;
	}


	public void retirerTete ( ) 
	{
		tete = tete.getSuivant ( ) ;
	}


	public void retirerQueue ( ) 
	{
		CelluleNoeud ptr;
		
		ptr = tete ;
		while ( ptr.getSuivant().getSuivant() != null) 
		{
			ptr = ptr.getSuivant();
		}
		ptr.setSuivant(null);
	}
	
	public Noeud retirerQueue (int i) 
	{
		CelluleNoeud ptr, dernier;
		
		ptr = tete;
		
		if (tete==null)	// erreur
			return null;
			
		if (tete.getSuivant()==null){
			dernier = tete;
			tete=null;
		}
		else
		{
			while ( ptr.getSuivant().getSuivant() != null) 
			{
				ptr = ptr.getSuivant();
			}
			dernier = ptr.getSuivant();
			ptr.setSuivant(null);
		}
		return dernier.getValeur();
	}
	
	public boolean contient(Noeud x) 
	{
		CelluleNoeud iterateur;

		iterateur = tete ;
		while(iterateur !=  null) 
		{
			if (iterateur.getValeur() == x) 
				return true;		// on quitte la methode
			iterateur = iterateur.getSuivant() ;
		}
		return false;
	}
	
	
	public void afficher ( ) 
	{
		CelluleNoeud ptr = tete ;
		while ( ptr != null) 
		{
			System.out.println(ptr.getValeur());
			ptr = ptr.getSuivant();
		}
		System.out.println("***");
	}
}

