<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
  "http://www.w3.org/TR/html4/loose.dtd">
<html><head>
<meta http-equiv="Content-Type"
      content="text/html; charset=iso-8859-1" />
<title>PHP Programming, mysqli sample</title>
</head><body>

<?php

// SQL commands with parameter

// Create connection
require_once 'password.php';
$mysqli = new mysqli($mysqlhost, $mysqluser, $mysqlpasswd, $mysqldb);

// test if connexion OK
if(mysqli_connect_errno()) {
  echo "<p>Sorry, no connection! ", mysqli_connect_error(), "</p>\n";
  exit();
}

// Prepare SQL command with parameter
$stmt = $mysqli->prepare(
  "INSERT INTO titles (title, subtitle, langID) VALUES (?, ?, ?)");
$stmt->bind_param('ssi', $title, $subtitle, $langID);

// Execute command several times
$title="new Linux title 1";
$subtitle="new subtitle 1";
$langID=1;
$stmt->execute();

$title="new MySQL title 2";
$subtitle="new subtitle 2";
$langID=2;
$stmt->execute();

// Free command
$stmt->close();

// Combination of bind_param and bind_result
$stmt = $mysqli->prepare(
  "SELECT titleID, title FROM titles WHERE title LIKE ?");
$stmt->bind_param('s', $pattern);

$pattern="%Linux%";
$stmt->execute();
$stmt->store_result();
$stmt->bind_result($titleID, $title);
echo "<p></p>\n";
while($stmt->fetch())
  printf("<br />%d %s\n", $titleID, htmlspecialchars($title));

$pattern="%MySQL%";
$stmt->execute();
$stmt->store_result();
$stmt->bind_result($titleID, $title);
echo "<p></p>\n";
while($stmt->fetch())
  printf("<br />%d %s\n", $titleID, htmlspecialchars($title));
$stmt->close();

// Delete new records
$mysqli->query("DELETE FROM titles WHERE title LIKE 'new %'");

// Close connexion
$mysqli->close();

?>
</body></html>
